package com.digiwin.athena.atdm.datasource.dto;

import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;


@Data
public class DataSourceDTO implements Serializable {
    /**
     * 数据源的名称
     */
    private String name;

    /**
     * 数据的key字段
     */
    private List<String> dataKeys;

    /**
     * 数据源类型
     */
    private String type;

    /**
     * tm中的actionid
     */
    private String actionId;

    /**
     * 数据的实际获取的action
     */
    private QueryAction action;

    /**
     * 查询的笔数
     */
    private Integer limit;

    /**
     * 是否为集合数据
     */
    private Boolean notArray;


    /**
     * 提供的数据源描述，如果数据源非esp的，或者通过actionid获取不到元数据的，可以通过这个集合来定义数据源的结果
     */
    private List<MetadataField> metadataFields;

    /**
     * 数据处理器
     */
    List<DataSourceProcessor>  dataSourceProcessors;

    /**
     * 左边的数据
     */
    private DataSourceDTO left;

    /**
     * 右边的数据源
     */
    private List<DataSourceDTO> rightList;

    /**
     * 如果有多个字段重复，是否重写
     */
    private Boolean override = false;


    /**
     * 直接获取数据
     */
    private HashMap<String,  Object> rawData;


    /**
     * 查询的数据源
     */
    private List<DataSourceDTO> unionItems;
    /**
     * 指定可以对union类型的数据做合并查询
     */
    private Boolean mergeQuery;

    /**
     * 扩展信息
     */
    private HashMap<String,  Object> extendedData;
}
