package com.digiwin.athena.atdm.iam;


import com.digiwin.athena.atdm.iam.dto.UserDTO;

public interface CommonUserService {
    /**
     * 根据用户id获取用户相关的信息
     *
     * @param userId 用户id
     * @param token  合法的token
     * @return 用户基本信息
     */
    UserDTO query(String userId, String token);

    /**
     * 通过用户ID获取员工ID
     *
     * @param userId 用户id
     * @return 用户基本信息
     */
    String getEmpIdByUserId(String userId, String token);

    /**
     * 查询用户类型
     *
     * @param userId
     * @param token
     * @return 0：内部用户；1：外部用户
     */
    Integer queryUserType(String userId, String token);
}

