package com.digiwin.athena.atdm.uibot;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.ptm.dto.PtmWorkItemDTO;
import com.digiwin.athena.atdm.uibot.dto.UiBotTaskWithdrawReqDTO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * UiBotServiceImpl Description
 *
 * @author majianfu
 * @date 2022/2/17
 * @since
 */
@Slf4j
@Service
public class CommonUiBotServiceImpl implements CommonUiBotService {
    @Resource
    private RemoteProperties remoteProperties;

    @Resource
    private RestTemplate restTemplate;

    @Resource
    private MessageUtils messageUtils;

    /**
     * {@inheritDoc}
     */
    @Override
    public Map queryTerminateDataPageDefine(String tmProjectId, String tmActivityId, Long workItemId, List bkList) {
        String url = MessageFormat.format(remoteProperties.getUibotUri() + "api/ai/v1/bot/terminateData/page/define/{0}/{1}/{2}", tmProjectId, tmActivityId, String.valueOf(workItemId));

        Map body = new HashMap();
        body.put("bkList", bkList);

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(body, headers);
        try {
            ResponseEntity<BaseResultDTO<Map>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, new ParameterizedTypeReference<BaseResultDTO<Map>>() {
            });
            return respEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            log.error("body: {}, error: ", JsonUtils.objectToString(body), ex);
            throw ex;
        }
    }

    @Override
    public List<Map> queryDataUniformityPageDefine(String tmProjectId, String tmActivityId, String workItemId) {
        String url = MessageFormat.format(remoteProperties.getUibotUri() + "api/ai/v1/bot/dataUniformity/pageDefine/{0}/{1}/{2}", tmProjectId, tmActivityId, workItemId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<List<Map>>> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, new ParameterizedTypeReference<BaseResultDTO<List<Map>>>() {
            });
            return respEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            log.error("url: {}, error: ", url, ex);
            throw ex;
        }
    }

    @Override
    public List<Map<String, Object>> getUnfinishedData(String tmProjectId, String tmActivityId, String workItemId) {
        String url = MessageFormat.format(remoteProperties.getUibotUri() + "api/ai/v1/data/query/unfinished/task/data/{0}/{1}/{2}", tmProjectId, tmActivityId, workItemId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<List<Map<String, Object>>>> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, new ParameterizedTypeReference<BaseResultDTO<List<Map<String, Object>>>>() {
            });
            return respEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            log.error("url: {}, error: ", url, ex);
            throw ex;
        }
    }

    @Override
    public Map<String, Object> getAFCData() {
        String url = remoteProperties.getIdriveBusinessReportUri() + "/api/v1/afc/report/queryModelInfo";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
            });
            return respEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            log.error("url: {}, error: ", url, ex);
            throw ex;
        }
    }

    @Override
    public Map<Long, List<Map>> queryTaskWithdrawPageDefine(List<UiBotTaskWithdrawReqDTO> uiBotTaskWithdrawReqList) {
        String url = remoteProperties.getUibotUri() + "api/ai/v1/bot/taskWithdraw/page/define";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(uiBotTaskWithdrawReqList, headers);
        try {
            ResponseEntity<BaseResultDTO<Map<Long, List<Map>>>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, new ParameterizedTypeReference<BaseResultDTO<Map<Long, List<Map>>>>() {
            });
            return respEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            String message = messageUtils.getMessage("exception.task.withdraw.invoke.uibot");
            log.error("{}, reqBody: {}, error:{}", message, JsonUtils.objectToString(uiBotTaskWithdrawReqList), ex.getMessage());
            throw ex;
        }
    }

    @Override
    public Map<Long, List<Map>> queryTaskCrossBkWithdrawPageDefine(List<PtmWorkItemDTO> uiBotTaskWithdrawReqList) {
        String url = remoteProperties.getUibotUri() + "api/ai/v1/bot/taskCrossBkWithdraw/page/define";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity reqEntity = new HttpEntity<>(uiBotTaskWithdrawReqList, headers);
        try {
            ResponseEntity<BaseResultDTO<Map<Long, List<Map>>>> respEntity = this.restTemplate.exchange(url, HttpMethod.POST, reqEntity, new ParameterizedTypeReference<BaseResultDTO<Map<Long, List<Map>>>>() {
            });
            return respEntity.getBody().getResponseWithException("");
        } catch (Exception ex) {
            String message = messageUtils.getMessage("exception.task.withdraw.invoke.uibot");
            log.error("{}, reqBody: {}, error:{}", message, JsonUtils.objectToString(uiBotTaskWithdrawReqList), ex.getMessage());
            throw ex;
        }
    }

    @Override
    public List<SubmitAction> getTaskPageSubmitActions(String tmTaskId, String tmActivityId, Map<String, Object> activityData) {
        String url = MessageFormat.format(remoteProperties.getUibotUri() + "/api/ai/v1/bot/task/submitactions/{0}/{1}", tmTaskId, tmActivityId);
        BaseResultDTO<List<SubmitAction>> resultDTO = DwSpringHttpUtil.post(url, activityData, new ParameterizedTypeReference<BaseResultDTO<List<SubmitAction>>>() {
        });

        return null != resultDTO ? resultDTO.getResponseWithException("获取作业按钮定义报错") : new ArrayList<>();
    }

}
