package com.digiwin.athena.atdm.datasource;

import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;
import com.digiwin.athena.atdm.datasource.domain.SubmitAction;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import lombok.Getter;
import lombok.Setter;

import java.util.Map;

@Getter
@Setter
public class ActionExecuteReq {

    private SubmitExecuteContext submitExecuteContext;
    private SubmitAction parentAction;
    private ExecuteResult parentExecuteResult;
    private SubmitAction action;
    private Map<String, Object> data ;
    private Map<Long, Map<String, Object>> workItemIdToData ;
    private ApiMetadata apiMetadata ;

    public ActionExecuteReq() {
    }

    public ActionExecuteReq(SubmitExecuteContext submitExecuteContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data) {
        this.submitExecuteContext = submitExecuteContext;
        this.parentExecuteResult = parentExecuteResult;
        this.action = action;
        this.data = data;
    }

    public ActionExecuteReq(SubmitExecuteContext submitExecuteContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data, ApiMetadata apiMetadata) {
        this.submitExecuteContext = submitExecuteContext;
        this.parentExecuteResult = parentExecuteResult;
        this.action = action;
        this.data = data;
        this.apiMetadata = apiMetadata;
    }

    public ActionExecuteReq(SubmitExecuteContext submitExecuteContext, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data, Map<Long, Map<String, Object>> workItemIdToData) {
        this.submitExecuteContext = submitExecuteContext;
        this.parentExecuteResult = parentExecuteResult;
        this.action = action;
        this.data = data;
        this.workItemIdToData = workItemIdToData;
    }

    public ActionExecuteReq(SubmitExecuteContext submitExecuteContext, SubmitAction parentAction, ExecuteResult parentExecuteResult, SubmitAction action, Map<String, Object> data, Map<Long, Map<String, Object>> workItemIdToData) {
        this.submitExecuteContext = submitExecuteContext;
        this.parentAction = parentAction;
        this.parentExecuteResult = parentExecuteResult;
        this.action = action;
        this.data = data;
        this.workItemIdToData = workItemIdToData;
    }
}
