package com.digiwin.athena.atdm.datasource.dto;

import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

@Data
public class DataSourceSetDTO {

    public static DataSourceSetDTO create(DataSourceDTO dataSourceBase){
        DataSourceSetDTO dataSourceSet = new DataSourceSetDTO();
        List<DataSourceDTO> dataSourceList =  new ArrayList<>();
        dataSourceList.add(dataSourceBase);
        dataSourceSet.setDataSourceList(dataSourceList);
        return dataSourceSet;
    }
    public  DataSourceSetDTO append(DataSourceDTO dataSourceBase){
       if (dataSourceList ==null) {
           this.dataSourceList = new ArrayList<>();
       }
        dataSourceList.add(dataSourceBase);
        return this;
    }

    /**
     * 查询的数据源
     */
    private List<DataSourceDTO> dataSourceList;

    private String mainDatasource;

    /**
     * 全局数据处理器
     */
    private List<DataSourceProcessor> dataProcess;

    /**
     * 数据状态（pending-待处理）
     */
    private String dataDtatus;
    /**
     * 处理数据的方式（retainDifferent-保留异动数据；deleteDifferent-删除异动数据）
     */
    private String dealDataType;

}
