package com.digiwin.athena.atdm.iam;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.atmc.UrlPathConstants;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.iam.dto.UserDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

@Slf4j
@Service
public class CommonUserServiceImpl implements CommonUserService {

    @Autowired
    protected RemoteProperties envProperties;

    @Autowired
    protected RestTemplate restTemplate;

    @Override
    public UserDTO query(String userId, String token) {
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        //post body
        Map<String, String> param = new HashMap<>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity<>(param, headers);
        String url = envProperties.getIamUri() + UrlPathConstants.IAM_USER_FULL_V2;
        try {
            ResponseEntity<UserDTO> responseEntity = restTemplate.postForEntity(url, httpEntity, UserDTO.class);
            return responseEntity.getBody();
        } catch (Exception ex) {
            log.error("{}, body: {}, error: ", ErrorCodeEnum.IAM_V2_USER.getErrCode(), JsonUtils.objectToString(param), ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.IAM_V2_USER.getErrCode(), ex);
        }
    }

    @Override
    public String getEmpIdByUserId(String userId, String token) {
        //获取员工ID
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        //post body
        Map<String, String> param = new HashMap<>();
        param.put("userId", userId);
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        String url = envProperties.getEocUri() + "api/eoc/v2/emp/id";
        try {
            ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url, httpEntity, Map.class);
            Map body = responseEntity.getBody();
            if (body == null) {
                return null;
            } else {
                return body.get("data").toString();
            }
        } catch (Exception ex) {
            log.error("{}, body: {}, error: ", ErrorCodeEnum.EOC_V2_EMP_ID.getErrCode(), JsonUtils.objectToString(param), ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.EOC_V2_EMP_ID.getErrCode(), ex);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Integer queryUserType(String userId, String token) {
        // 获取员工ID
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        // post body
        Map<String, String> param = new HashMap<>();
        param.put("userId", userId);
        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        String url = envProperties.getIamUri() + "/api/iam/v2/query/user";
        try {
            ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url, httpEntity, Map.class);
            Map body = responseEntity.getBody();
            if (body == null) {
                return null;
            } else {
                return (Integer) body.get("userType");
            }
        } catch (Exception ex) {
            log.error("{}, body: {}, error: ", ErrorCodeEnum.IAM_V2_QUERY_USER.getErrCode(), JsonUtils.objectToString(param), ex);
            throw ExceptionUtil.wrap(ErrorCodeEnum.IAM_V2_QUERY_USER.getErrCode(), ex);
        }
    }
}
