package com.digiwin.athena.atdm.terminateData;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.terminateData.dto.TerminateDataDTO;

import java.util.Collection;
import java.util.List;

/**
 * TerminateDataService Description
 *
 * @author majianfu
 * @date 2022/2/17
 * @since
 */
public interface CommonTerminateDataService {
    /**
     * 保存被终止的任务数据信息
     *
     * @param authoredUser
     */
    void saveTerminateData(AuthoredUser authoredUser, TerminateDataDTO terminateDataDTO);

    void saveTerminateData(AuthoredUser authoredUser, List<TerminateDataDTO> dataDTOList);

    /**
     * 根据作业id，查询作业终止数据列表
     *
     * @param token
     * @param tenantId
     * @param userId
     * @param activityCode
     * @param activityIds
     * @return
     */
    List queryTerminateDataList(String token, String tenantId, String userId, String activityCode, Collection<String> activityIds);
}
