/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.activity;

import com.digiwin.athena.atdm.activity.domain.TmQueryAction;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class DataSourceDTOFactory {
    public static DataSourceDTO createDataSource(List<QueryAction> actionList, List<DataSourceProcessor> dataSourceProcessors, String key, TmQueryAction tmAction) {
        if (actionList.size() > 1) {
            DataSourceDTO unionDataSource = new DataSourceDTO();
            ArrayList<DataSourceDTO> unionItems = new ArrayList<DataSourceDTO>();
            int count = 1;
            for (QueryAction action : actionList) {
                DataSourceDTO dataSourceBase = DataSourceDTOFactory.create(tmAction, action, key + count, dataSourceProcessors, false);
                if (dataSourceBase != null) {
                    unionItems.add(dataSourceBase);
                }
                ++count;
            }
            unionDataSource.setActionId(actionList.get(0).getActionId());
            unionDataSource.setName(key);
            unionDataSource.setUnionItems(unionItems);
            unionDataSource.setDataKeys(tmAction.getDataKeys());
            unionDataSource.setMetadataFields(tmAction.getMetadataFields());
            return unionDataSource;
        }
        QueryAction action = actionList.get(0);
        DataSourceDTO dataSource = DataSourceDTOFactory.create(tmAction, action, key, dataSourceProcessors, false);
        return dataSource;
    }

    public static DataSourceDTO create(TmQueryAction tmAction, QueryAction action, String key, List<DataSourceProcessor> dataSourceProcessors, boolean isRoot) {
        if (StringUtils.isEmpty((Object)key) && tmAction != null) {
            key = tmAction.getName();
        }
        DataSourceDTO dataSource = null;
        switch (action.getCategory()) {
            case "ESP": {
                DataSourceDTO espDataSource = new DataSourceDTO();
                espDataSource.setType("ESP");
                dataSource = espDataSource;
                break;
            }
            case "TM": {
                if (action.getActionId().equals("sm_iqc.get.old") || action.getActionId().equals("sm_iqc.get.new")) {
                    DataSourceDTO tmFormulaDataSource = new DataSourceDTO();
                    tmFormulaDataSource.setType("TM");
                    dataSource = tmFormulaDataSource;
                    break;
                }
                if (action.getActionId().equals("athena_MechanismRecordGet")) {
                    DataSourceDTO tmDataSource = new DataSourceDTO();
                    tmDataSource.setType("TM");
                    dataSource = tmDataSource;
                    break;
                }
                if (!action.getActionId().equals("athena_TimeIntervalCodeGet")) break;
                DataSourceDTO tmDataSource = new DataSourceDTO();
                tmDataSource.setType("TM");
                dataSource = tmDataSource;
                break;
            }
            case "RAWDATA": {
                DataSourceDTO rawDataSource = new DataSourceDTO();
                rawDataSource.setName(key);
                rawDataSource.setType("RAWDATA");
                if (!CollectionUtils.isEmpty(action.getParas())) {
                    HashMap value = (HashMap)action.getParas();
                    rawDataSource.setRawData(value);
                }
                dataSource = rawDataSource;
                break;
            }
            case "SD": {
                DataSourceDTO sdDataSource = new DataSourceDTO();
                sdDataSource.setType("SD");
                dataSource = sdDataSource;
                break;
            }
        }
        if (dataSource != null) {
            dataSource.setAction(action);
            dataSource.setActionId(tmAction.getActionId());
            dataSource.setName(key);
            dataSource.setDataSourceProcessors(dataSourceProcessors);
            dataSource.setDataKeys(tmAction.getDataKeys());
            dataSource.setLimit(tmAction.getLimit());
            dataSource.setNotArray(tmAction.getNotArray());
            dataSource.setOverride(tmAction.getOverride());
        }
        if (isRoot) {
            dataSource.setMetadataFields(tmAction.getMetadataFields());
        }
        return dataSource;
    }
}

