/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.adsc;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.adsc.CommonAdscService;
import com.digiwin.athena.atdm.adsc.dto.AdscDataConditionQueryDto;
import com.digiwin.athena.atdm.adsc.dto.AdscDataQueryDTO;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonAdscServiceImpl
implements CommonAdscService {
    private static final Logger logger = LoggerFactory.getLogger(CommonAdscServiceImpl.class);
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public HashMap<String, Object> query(ExecuteContext executeContext, Action action, Map<String, Object> parameter, PageInfo pageInfo, List<Map> orderInfo, List<Map> searchInfo) {
        String url = this.envProperties.getWebAdscUri() + "/api/appdata/page";
        AdscDataQueryDTO reqBody = new AdscDataQueryDTO();
        reqBody.setExecuteContext(executeContext);
        reqBody.setAction(action);
        reqBody.setParameter(parameter);
        reqBody.setPageInfo(pageInfo);
        reqBody.setSortInfo(orderInfo);
        reqBody.setSearchInfo(searchInfo);
        reqBody.setDataStateCode(executeContext.getDataStateCode());
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)reqBody, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<HashMap<String, Object>>>(){}, new Object[0]);
            if (((BaseResultDTO)respEntity.getBody()).isOK()) {
                return (HashMap)((BaseResultDTO)respEntity.getBody()).getResponse();
            }
        }
        catch (Exception e) {
            logger.error("{}, body: {}, \u67e5\u8be2adsc\u6570\u636e\u5206\u9875\u670d\u52a1\u5f02\u5e38\uff1a", new Object[]{ErrorCodeEnum.ADSC_QUERY.getErrCode(), JsonUtils.objectToString((Object)reqBody), e});
            throw BusinessException.create((String)ErrorCodeEnum.ADSC_QUERY.getErrCode(), (String)("\u67e5\u8be2adsc\u6570\u636e\u5206\u9875\u670d\u52a1\u5f02\u5e38:" + e.getMessage()));
        }
        return new HashMap<String, Object>();
    }

    @Override
    public Map<String, List<Map>> queryConditions(ExecuteContext executeContext, List<String> conditionFileds, List<Map> searchInfos) {
        String url = this.envProperties.getWebAdscUri() + "/api/appdata/page/queryConditions";
        AdscDataConditionQueryDto adscDataQueryDto = new AdscDataConditionQueryDto(executeContext, conditionFileds, searchInfos);
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)adscDataQueryDto, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map<String, List<Map>>>>(){}, new Object[0]);
            if (((BaseResultDTO)respEntity.getBody()).isOK()) {
                return (Map)((BaseResultDTO)respEntity.getBody()).getResponse();
            }
        }
        catch (Exception e) {
            logger.error("{}, body: {}, \u67e5\u8be2adsc\u5b57\u6bb5\u7edf\u8ba1\u670d\u52a1\u5f02\u5e38\uff1a", new Object[]{ErrorCodeEnum.ADSC_QUERY_CONDITIONS.getErrCode(), JsonUtils.objectToString((Object)adscDataQueryDto), e});
            throw BusinessException.create((String)ErrorCodeEnum.ADSC_QUERY_CONDITIONS.getErrCode(), (String)("\u67e5\u8be2adsc\u5b57\u6bb5\u7edf\u8ba1\u670d\u52a1\u5f02\u5e38:" + e.getMessage()));
        }
        return new HashMap<String, List<Map>>();
    }
}

