/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.lcdp;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.lcdp.CommonLcdpService;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CommonLcdpServiceImpl
implements CommonLcdpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonLcdpServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private RemoteProperties envProperties;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public HashMap<String, Object> query(ExecuteContext executeContext, Action action) {
        String url = this.envProperties.getWebLcdpUri() + action.getServiceId().getServiceUri();
        HashMap<String, Map<String, Object>> body = new HashMap<String, Map<String, Object>>();
        body.put("params", action.getParas());
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON);
        if (AppAuthContextHolder.getContext().getProxyAuthoredUser() != null) {
            headerMap.add("token", AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken());
        } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            headerMap.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        }
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headerMap);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, HashMap.class, new Object[0]);
            if (responseEntity.getStatusCode() != null && 200 == responseEntity.getStatusCode().value()) {
                Map response;
                HashMap result = (HashMap)responseEntity.getBody();
                if (result.containsKey("response") && result.get("response") instanceof Map && (response = (Map)result.get("response")).containsKey("success") && !Boolean.valueOf(response.get("success").toString()).booleanValue()) {
                    String message = result.get("response").toString();
                    if (response.containsKey("message")) {
                        message = response.get("message").toString();
                    }
                    throw BusinessException.create((String)ErrorCodeEnum.LDCP_QUERY.getErrCode(), (String)message);
                }
                if (result instanceof Map) {
                    return result;
                }
                return null;
            }
            throw BusinessException.create((String)ErrorCodeEnum.LDCP_QUERY.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.execution.lcdp"), action.getServiceId().getServiceUri(), ((HashMap)responseEntity.getBody()).toString()));
        }
        catch (Exception e) {
            log.error("[execute] {}, body: {}", (Object)ErrorCodeEnum.LDCP_QUERY.getErrCode(), (Object)JsonUtils.objectToString(body));
            throw BusinessException.create((String)ErrorCodeEnum.LDCP_QUERY.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.execution.lcdp"), action.getServiceId().getServiceUri(), e.getMessage()));
        }
    }

    @Override
    public HashMap<String, Object> execute(SubmitExecuteContext executeContext, Action action) {
        String url = this.envProperties.getWebLcdpUri() + action.getServiceId().getServiceUri();
        HashMap<String, Map<String, Object>> body = new HashMap<String, Map<String, Object>>();
        body.put("params", action.getParas());
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON);
        if (AppAuthContextHolder.getContext().getProxyAuthoredUser() != null) {
            headerMap.add("token", AppAuthContextHolder.getContext().getProxyAuthoredUser().getToken());
        } else if (AppAuthContextHolder.getContext().getAuthoredUser() != null) {
            headerMap.add("token", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        }
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headerMap);
        try {
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, HashMap.class, new Object[0]);
            if (responseEntity.getStatusCode() != null && 200 == responseEntity.getStatusCode().value()) {
                Map response;
                HashMap result = (HashMap)responseEntity.getBody();
                if (result.containsKey("response") && result.get("response") instanceof Map && (response = (Map)result.get("response")).containsKey("success") && !Boolean.valueOf(response.get("success").toString()).booleanValue()) {
                    String message = result.get("response").toString();
                    if (response.containsKey("message")) {
                        message = response.get("message").toString();
                    }
                    throw BusinessException.create((String)ErrorCodeEnum.LDCP_EXECUTE.getErrCode(), (String)message);
                }
                if (result instanceof Map) {
                    return result;
                }
                return null;
            }
            throw BusinessException.create((String)ErrorCodeEnum.LDCP_EXECUTE.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.execution.lcdp.submit"), action.getServiceId().getServiceUri(), ((HashMap)responseEntity.getBody()).toString()));
        }
        catch (Exception e) {
            log.error("[execute] {}, body: {}", (Object)ErrorCodeEnum.LDCP_EXECUTE.getErrCode(), (Object)JsonUtils.objectToString(body));
            throw BusinessException.create((String)ErrorCodeEnum.LDCP_EXECUTE.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.execution.lcdp.submit"), action.getServiceId().getServiceUri(), e.getMessage()));
        }
    }
}

