package com.digiwin.athena.atdm.activity.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import net.sf.json.JSONObject;

import java.util.List;
import java.util.Map;

/**
 * @description: ThemeMap任务定义Page中的dataState，用于替换以前的TmPage内容
 * @author: zhujg
 * @create: 2021-03-02 14:31
 **/
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Data
public class TmDataState {

    /**
     * 主键，必须有
     */
    private String code;

//    /**
//     * 数据状态
//     */
//    private List<String> dataState;

    /**
     * dataFilter的code，表示使用的dataFilter
     */
    private String dataFilterCode;

    /**
     * 提交ACTION
     */
    private List<TmAction> submitActions;

    /**
     * 扩展字段，临时存放
     * 目前在模板中使用，以后需要重新定义结构
     */
    private Map<String,Object> extendedFields;


    /**
     * 勾选是否合并选择
     */
    private Boolean multipleSelectMerge;

    /**
     * 自定义标签
     */
    private List<TmSummaryField> summaryFields;

    /**
     * table 分组设置
     */
    private JSONObject settings;

    /**
     * 撤回的action定义
     */
    TmAction abortTaskAction;

    /**
     * 提交的数据schema集合，不指定表示提交全部数据
     * <br>指定后，提交时只提交指定的数据
     */
    private List<String> submitSchemas;
}