package com.digiwin.athena.atdm.audc.dto;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Map;

/**
 * UserTrackExtendDTO Description
 *
 * @date 2021/9/2
 * @since
 */
@Getter
@Setter
@NoArgsConstructor
public class UserTrackExtendDTO {
    /**
     * 记录的落表时间-时间戳
     */
    private Long createDate;

    /**
     * 记录的落表时间-格式化后的字符串
     */
    private String createDateStr;

    /**
     * 利用雪花生成的唯一ID
     */
    private Long uniqueId;

    /**
     * 客户端id，方便FI关联前后上报行为上报，计算耗时等
     */
    private String clientId;

    /**
     * 来源（大小写不敏感）：
     * performance_analysis : 性能分析
     * function_analysis : 功能分析
     * null : 用户行为上报
     */
    private String source;

    private String sessionId;
    /**
     * 用户id
     */
    private String userId;

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 操作时间点，时间戳
     */
    private Long timestamp;

    /**
     * 执行的操作，如：打开查看：OPEN，提交：SUBMIT
     */
    private String operation;

    /**
     * 操作类型名称，应用配置的名称，未配置为空。
     */
    private String operationName;

    /**
     * 操作位置,当前行：row；针对表格：all；单元格底部：line
     */
    private String mode;

    /**
     * opertion.attach.target,
     * action.submitType.schema等
     */
    private String target;

    /**
     * 表格、表单的title
     */
    private String targetName;

    /**
     * operation.attach.applyToField
     */
    private String field;

    /**
     * operation.attach.applyToField的表头名称、表单名称
     */
    private String fieldName;

    /**
     * 作业类型，如：任务 task， 项目：Project，报表：report，基础资料录入：base-data
     */
    private String workType;

    /**
     * 作业pattern，如：任务：BUSINESS
     */
    private String workPattern;

    /**
     * 作业类别，如：基础资料录入-单档类型：SIGN-DOCUMENT
     */
    private String workCategory;

    /**
     * 作业ThemeMap定义的code，如：基础资料录入-客户建立：baseDataEntry_clients
     */
    private String workCode;

    /**
     * 作业内容，如：id、startTime、endTime
     */
    private Map<String, Object> workContent;

    /**
     * 附加信息
     */
    private Map<String, Object> attachData;
}
