package com.digiwin.athena.atdm.esp;

import com.digiwin.athena.atdm.datasource.domain.*;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CommonESPService {


    /**
     * 直接接口查询API数据
     * @param action
     * @param parameter
     * @return
     */
    HashMap<String,Object> query(ExecuteContext executeContext, Action action, Map<String, Object> parameter);


    /**
     * 执行
     * @param executeContext
     * @param action
     * @return
     */
    HashMap<String,Object> execute(SubmitExecuteContext executeContext, Action action);


    /**
     * 获取esp元数据
     * */
    String getApiMetadataInvokeType(String apiName);


    /**
     * 获取指定租户的全局参数
     * @param executeContext
     * @return
     */
    HashMap<String,Object> queryByApiName(ExecuteContext executeContext, String apiName , Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo);

    /**
     * 执行
     * @param executeContext
     * @param action
     * @return
     */
    HashMap<String,Object> executeReturnAll(SubmitExecuteContext executeContext, Action action);

//    /**
//     * 根据租户id和api名称获取产品信息
//     * @param tenantId 租户id
//     * @param apiName api名称
//     * @return 产品信息列表
//     */
//    String getTenantProductList(String tenantId, String apiName);
}
