package com.digiwin.athena.atdm.fi;

import com.digiwin.athena.atdm.RemoteProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 智能预测服务
 */
@Slf4j
@Service
public class CommonForecastingIntelligenceServiceImpl implements CommonForecastingIntelligenceService {

    @Autowired
    private RemoteProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    public Map<String,Object> taskaction(Map data, Map user, Map task, List<Map> fiAmendData){

        String uri = MessageFormat.format("{0}/{1}", envProperties.getFiUri(), "FIRecommend_taskaction/");

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        Map<String,Object> parameter = new HashMap<>();
        parameter.put("data", data);
        parameter.put("user", user);
        parameter.put("task", task);
        parameter.put("fi_amend_data", fiAmendData);

        HashMap result = null;
        HttpEntity httpEntity = new HttpEntity<Map>(parameter,headers);
        try {
            ResponseEntity<HashMap> responseEntity = restTemplate.postForEntity(uri, httpEntity, HashMap.class);
            result = responseEntity.getBody();
            if (result.containsKey("response")) {
                if (result.get("response") instanceof Map) {
                    result = (HashMap) result.get("response");
                } else {
                    return null;
                }
            } else {
                return null;
            }
        }
        catch (Exception e){
            log.error("taskaction error: {}", e);
        }
        return result;

    }

    public Map<String,Object> taskSubmit(Map data, Map user, Map task, Map context){
        String uri = MessageFormat.format("{0}/{1}", envProperties.getFiUri(), "FIRecommend_tasksubmit/");

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        Map<String,Object> parameter = new HashMap<>();
        parameter.put("data", data);
        parameter.put("user", user);
        parameter.put("task", task);
        parameter.put("context", context);

        HashMap result = null;
        HttpEntity httpEntity = new HttpEntity<Map>(parameter,headers);
        try {
            ResponseEntity<HashMap> responseEntity = restTemplate.postForEntity(uri, httpEntity, HashMap.class);
            result = responseEntity.getBody();
            if (result.containsKey("response")) {
                if (result.get("response") instanceof Map) {
                    result = (HashMap) result.get("response");
                } else {
                    return null;
                }
            } else {
                return null;
            }
        }
        catch (Exception e){
            log.error("taskSubmit error: {}", e);
        }
        return result;
    }
}
