package com.digiwin.athena.atdm.adsc.dto;

import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * adsc数据查询入口dto
 *
 * @author jianglpc
 * @version 1.0
 * @since 2023/3/3
 */
@Data
public class AdscDataConditionQueryDto implements Serializable {

    /**
     * 执行上下文
     */
    private ExecuteContext executeContext;

    /**
     * 查询字段名
     */
    private List<String> conditionFileds;

    /**
     * 搜索条件
     */
    private List<Map> searchInfo;

    public AdscDataConditionQueryDto() {

    }

    public AdscDataConditionQueryDto(ExecuteContext executeContext, List<String> conditionFileds, List<Map> searchInfos) {
        this.executeContext = executeContext;
        this.conditionFileds = conditionFileds;
        this.searchInfo = searchInfos;
    }
}
