package com.digiwin.athena.atdm.datasource.domain;

import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @description: 活动--backlog 数据
 * @author: wangminga
 * @create: 2020-09-03 11:02
 **/
@Data
public class BacklogData implements Serializable {

    /**
     * 代办ID
     */
    private Long backlogId;

    /**
     * 执行者ID
     */
    private String performerId;


    /**
     * 提交唯一键
     */
    private Integer submitId;

    /**
     * 人员状态true在职，false离职
     */
    private Boolean performerState;

    /**
     * 执行者名称
     */
    private String performerName;


    /**
     * 前置任务的所有者id
     */
    private String prePerformerId;

    /**
     * 前置任务所有者名称
     */
    private String  prePerformerName;

    /**
     * 当责者代理人的id
     */
    private String performerAgentId;

    /**
     * 当责者代理人名称
     */
    private String performerAgentName;

    //如果提交的是代理人或者辅助者执行者，则记录
    private String preAgentPerformerId;
    private String  preAgentPerformerName;
    /**
     * 如果是1，是代理人执行，是2，辅助执行者执行
     */
    private Integer prePerformerType;

    /**
     * 已读次数
     */
    private Integer readCount;

    /**
     * 开始时间
     */
    private String startTime;

    /**
     * 计划结束时间
     */
    private String planEndTime;

    /**
     * 没有endTime  就是未完成
     */
    private String endTime;

    /**
     * 倒计时
     */
    private String remainTime;

    /**
     * 逾期
     * 倒计时与逾期最多有一个，或者都没有
     */
    private String overdueDate;

    /**
     * 关卡处理的人
     */
    private List<Map<String,Object>> workitemList;

    /**
     * 是否已经处理过标记
     */
    private String finishedActionId;

    /**
     * 是否已经关闭
     */
    private boolean closed;

    private String bpmSignReason;

    /**
     * 待办名称
     */
    private String backlogName;

    private String processSerialNumber;

    private Long ptmBacklogId;
    private Long ptmWorkItemId;

    /**
     * taskUid，任务引擎才会有
     */
    private String taskUid;

    /**
     * 0.正常产生;1.转派；2.退回重签；3.退回重办；4.加签；9.撤回重办
     */
    private Integer createType;

    /**
     *  项目(流程)的状态，是否关闭。值按照现有的定义，3表示已关闭
     */
    private Integer projectState;
}
