package com.digiwin.athena.atdm.thememap;



import com.digiwin.athena.atdm.activity.domain.TmActivity;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.SubmitExecuteContext;
import com.digiwin.athena.atdm.thememap.dto.ActionInfo;
import com.digiwin.athena.atdm.thememap.dto.BaseItemDto;
import com.digiwin.athena.atdm.thememap.dto.SuggestPlanItemsDTO;
import com.digiwin.athena.atdm.thememap.dto.TmAppDTO;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CommonThemeMapService {

    HashMap<String,Object> executeFormula(String formulaId);


    HashMap<String,Object> post(String uri, Map parameter);

    HashMap<String,Object> postByRelativeUri(String relativeUri, Map parameter);

    /**
     * 获取方案数据
     * @return
     */
    List<SuggestPlanItemsDTO> getSuggestPlan(String locale, String decisionCode, List<Map<String,Object>> data);

    /**
     * 获取TM 活动的定义
     * @param pageContext
     * @return
     */
    TmActivity getActivityAction(ExecuteContext pageContext);


    /**
     * 追加action相关的信息
     * @param tenantId
     * @param actionId
     */
    ActionInfo getActionInfo(String tenantId, String actionId);

    /**
     * 查询km
     * @param value
     * @param context
     * @return
     */
    Object queryVariable(String value, SubmitExecuteContext context);

    /**
     * 从KM查询交付设计器设置的变量
     *
     * @param tenantId
     * @param locale
     * @param value
     * @return
     */
    Object queryVariable(String tenantId, String locale, String value);
}
