package com.digiwin.athena.atdm.annocache;


import cn.hutool.extra.expression.ExpressionUtil;
import com.digiwin.athena.appcore.auth.AppAuthContext;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.atdm.semc.dto.EncryptedConfigDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Aspect
@Component("cacheAspect")
@Slf4j
@Order(100)
public class CacheAspect {

    public static final String cachePrefixWord = "uibot:cache:";
    public static final String cachePrefix0="'uibot:cache:'+";
    public static final String cachePrefix_tenant=cachePrefix0+"ctx_auth.authoredUser.tenantId+':'+";
    public static final String cachePrefix_tenantLang=cachePrefix0+"ctx_auth.authoredUser.tenantId+':'+ctx_locale+':'+";
    public static final String cachePrefix_tenantUser=cachePrefix0+"ctx_auth.authoredUser.tenantId+':'+ctx_auth.authoredUser.userId+':'+";
    public static final String cachePrefix_tenantUserLang=cachePrefix0+"ctx_auth.authoredUser.tenantId+':'+ctx_locale+':'+ctx_auth.authoredUser.userId+':'+";


    @Autowired
    @Qualifier("annoRedisTemplate")
    private RedisTemplate redisTemplate;

    @Around("@annotation(com.digiwin.athena.atdm.annocache.Cache)")
    public Object processCache(ProceedingJoinPoint jp) throws Throwable {
        if(!Boolean.TRUE.equals(JaProperty.getBoolean("uibot.cache.enable",true))){
            return jp.proceed();
        }
        final Signature sig = jp.getSignature();
        final MethodSignature msig = (MethodSignature) sig;
        final Method method = msig.getMethod();
        final Cache annotation = method.getAnnotation(Cache.class);
        String key = annotation.key();
        if(StringUtils.isEmpty(key)){
            return jp.proceed();
        }
        Map<String,Object> param = new HashMap<>();
        Object[] args = jp.getArgs();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; i++) {
            Parameter parameter = parameters[i];
            String parameterName = parameter.getName();
            Object parameterValue = args[i];
            param.put(parameterName,parameterValue);
        }
        Object keyObj =  evalExpressionWithContext(key,param);
        Object result = redisTemplate.opsForValue().get(keyObj);
        if(null!=result){
            return result;
        }
        if(annotation.cacheNull() && redisTemplate.hasKey(keyObj) ){
            return result;
        }
        result = jp.proceed();
        if(null!=result || annotation.cacheNull()){
            redisTemplate.opsForValue().set(keyObj,result, annotation.ttlSecs(),TimeUnit.SECONDS);
        }
        return result;
    }

    /*
ctx包含属性 token,security-token,tenantId,userId,locale
{tenantName=pass区测试租户(E10_6.0), tenantSid=380745286255168, tenantId=E10ATHENApass, userSid=381050902839872, userName=业务员1, userId=E10PASS14}
 */
    public static Object evalExpressionWithContext(String expression, Map<String,Object> data)  {
        Map<String,Object> root = new HashMap<>();
        AppAuthContext ctx = AppAuthContextHolder.getContext();
        root.put("ctx_auth",ctx);
        root.put("ctx_locale",getLocale());
        if(null!=data){
            root.putAll(data);
        }
        return evalExpression(expression,root);
    }

    public static Object evalExpression(String expression, Map<String,Object> data)  {
        Object obj = ExpressionUtil.eval(expression,data);
        return obj;
    }

    public static String getLocale(){
        String locale = LocaleContextHolder.getLocale().toLanguageTag();
        if (StringUtils.isEmpty(locale)) {
            locale = "zh_CN";
        }
        return locale;
    }

    public static void main(String[] args) {
        Map<String,Object> param = new HashMap<>();
        param.put("a",2);
        param.put("b",2);
//        System.out.println(evalExpression("a+b+'_'+",param));

        EncryptedConfigDTO dto = new EncryptedConfigDTO();
        dto.setPattern("p1");
        dto.setActivityCode("aaa");
        param.put("dto",dto);

        System.out.println(evalExpression("'key_'+dto.getPattern()+dto.getActivityCode()",param));
        org.mvel2.MVEL aa;
    }


}
