package com.digiwin.athena.atdm.atmc;


import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atdm.activity.domain.SubmitActionDTO;
import com.digiwin.athena.atdm.atmc.dto.ActivityData;
import com.digiwin.athena.atdm.atmc.dto.ApiErrorInfoDTO;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.ExecuteResult;

import java.util.List;
import java.util.Map;

public interface CommonAtmcService {
    void emptyActivityData(Map data);

    void resetActivityData(Map data);

    /**
     * 跟踪数据的状态
     *
     * @param backlogId
     * @param data
     */
    void setBpmActivityTraceData(String backlogId, String startDataState, String targetDataState, Map data);

    void setBpmActivityStateData(String backlogId, Map data);

    /**
     * 撤回关卡
     *
     * @param processSerialNumber
     * @param workitemId
     */
    void abortTask(Long originalBacklogId, String processSerialNumber, String workitemId);

    /**
     * 关闭指定任务
     *
     * @param backlogId
     */
    void closeBpmActivityByBacklog(Long backlogId);

    /**
     * 更新待办的签核状态
     *
     * @param data
     */
    void updateBacklogApprovalState(Map<String, Object> data);

    List<Map> getChangeTaskDataSource(Map param);

    List<Map> getOverdueTaskDataSource(Map param);

    List<Map> saveOverdueTaskDataSource(Map param);

    List<Map> getOverdueTaskListDataSource(Map param);

    void sendEmailToHandleApiExecuteError(String type, Object emailData);

    List<Map> getConfig(List<String> configName);

    void closeApiExecuteErrorWorkItem(String processSerialNumber);

    /**
     * 创建、修改、删除手动任务
     *
     * @return
     */
    BaseResultDTO manualTaskStateChanged(List<Map<String, Object>> dataList);

    /**
     * 查询businessKey关联的任务/项目列表
     *
     * @param type
     * @param backlogId
     * @param bkList
     * @param forceNeedEntityName
     * @return
     */
    List<Map> queryCardListByBk(String type, Long backlogId, List<Map> bkList, boolean forceNeedEntityName);

    /**
     * 执行数据源业务数据查询
     *
     * @param executeContext
     * @param action
     * @param parameter
     * @return
     */
    List<Object> executeDataSourceDataQuery(ExecuteContext executeContext, Action action, Map<String, Object> parameter);

    /**
     * 获取PTM-Data，专用于PTM的 submit-data Action
     *
     * @param workItemId
     * @return
     */
    Map getPtmData(Long workItemId);

    /**
     * 根据id获取任务信息
     *
     * @Author：SYQ
     * @Date：2022/5/24 11:09
     */
    Map getBpmWorkItemById(Long workitemId);

    /**
     * 关闭数据一致性异常排除任务卡
     *
     * @Author：SYQ
     * @Date：2022/5/30 19:17
     */
    void closeDataUniformityBacklog(Long workitem, String actionId, String dataFrom);

    /**
     * 根据作业id，查询作业名称
     *
     * @param workItemIdList
     * @param backlogIdList
     * @return
     */
    Map<String, String> queryActivityNameById(List<String> workItemIdList, List<String> backlogIdList);

    /**
     * 向运维模组发送api错误数据
     *
     * @param apiErrorInfoDTO
     */
    void sendApiErrorInfoMq(ApiErrorInfoDTO apiErrorInfoDTO);


    /**
     * 检查atmc配置项是否存在
     *
     * @param name       value
     * @param operation  0查询，1删除，2新增
     * @param configName 配置项名称
     * @return
     */
    Boolean operationConfig(String name, Integer operation, String configName);

    /**
     * 任务--获取ATMC数据
     *
     * @param backlogId
     * @param pageContext
     * @return
     */
    ActivityData getTaskData(String backlogId, ExecuteContext pageContext);

    /**
     * 获取任务信息
     *
     * @param backlogId
     * @param isHistory
     * @return
     */
    Map getTaskData(String backlogId, Boolean isHistory);

    /**
     * 知会通知
     *
     * @param type
     * @param backlogId
     * @param users
     */
    void signNotice(Integer type, Long backlogId, List<Map<String, Object>> users);

    ExecuteResult executeCalendarAction(SubmitActionDTO submitAction);

    ExecuteResult executeAction(SubmitActionDTO submitAction);

    ExecuteResult executeActiontask(SubmitActionDTO submitAction);
}
