package com.digiwin.athena.atdm.semc;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.atdm.RemoteProperties;
import com.digiwin.athena.atdm.semc.dto.FineReportVO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author qinqiang
 * @date 2025/8/15 14:31
 * @description: 智能入口帆软报表数据获取
 */
@Slf4j
@Service
public class FineReportServiceImpl implements FineReportService {
    @Autowired
    private RemoteProperties envProperties;

    private static final String GET_FINE_REPORT_URL = "/semc/tripartite/fineReport/auth/queryFineReportList";

    private static final ParameterizedTypeReference<BaseResultDTO<FineReportVO>> getFineReportRespType = new ParameterizedTypeReference<BaseResultDTO<FineReportVO>>() {
    };

    /**
     * 获取帆软报表列表
     *
     * @param deviceType 设备类型，1:PC 2:移动
     * @return 帆软报表列表
     */
    @Override
    public List<FineReportVO.FineReportVOItem> getFineReportList(int deviceType) {
        String url = envProperties.getSemcUri() + GET_FINE_REPORT_URL;
        Map<String, Object> params = new HashMap<>();
        params.put("deviceType", deviceType);
        params.put("displayPermissionFlag", true);
        BaseResultDTO<FineReportVO> baseResultDTO = DwSpringHttpUtil.post(url, params, getFineReportRespType);
        FineReportVO fineReportVO = baseResultDTO.data();
        if (fineReportVO != null && CollectionUtils.isNotEmpty(fineReportVO.getFineReportList())) {
            List<FineReportVO.FineReportVOItem> fineReportList = fineReportVO.getFineReportList();
            if (fineReportVO.getAllAuthFlag() != null && fineReportVO.getAllAuthFlag() == 0) {
                fineReportList = fineReportVO.getFineReportList().stream().filter(item -> item.getHavePermissionFlag() != null && item.getHavePermissionFlag()).collect(Collectors.toList());
            }
            return fineReportList;
        }
        return Collections.emptyList();
    }
}
