package com.digiwin.athena.atdm.statemanagement;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;


/**
 * 数据状态表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
@Accessors(chain = true)
public class StateManagementDO  {

    private Long id;

    /**
     * 租户Id
     */
    private String tenantId;

    /**
     * 所属流程id
     */
    private String processSerialNumber;

    /**
     * tm中定义的任务Id
     */
    private String tmActivityId;

    /**
     * 数据所属API
     */
    private String actionId;

    /**
     * 动态任务的id,参与项目卡合并计算
     */
    private String compositionId;

    /**
     * 数据主键
     */
    private List<StateManagementDataKeyDO> businessKeys;

    /**
     * 创建日期
     */
    private LocalDateTime createDate;

    /**
     * 更新日期
     */
    private LocalDateTime modifyDate;
}
