package com.digiwin.athena.atdm.activity;

import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.activity.domain.TmQueryAction;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.dto.DataSourceDTO;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class DataSourceDTOFactory {
    public static DataSourceDTO createDataSource(List<QueryAction> actionList, List<DataSourceProcessor> dataSourceProcessors, String key, TmQueryAction tmAction) {
        if (actionList.size()>1){
            DataSourceDTO unionDataSource=new DataSourceDTO();
            List<DataSourceDTO> unionItems = new ArrayList<>();
            int count=1;
            for (QueryAction action : actionList) {
                DataSourceDTO dataSourceBase = DataSourceDTOFactory.create(tmAction, action,key + count, dataSourceProcessors,false);
                if (dataSourceBase!=null) {
                    unionItems.add(dataSourceBase);
                }
                count++;
            }
            unionDataSource.setActionId(actionList.get(0).getActionId());
            unionDataSource.setName(key);
            unionDataSource.setUnionItems(unionItems);
            unionDataSource.setDataKeys(tmAction.getDataKeys());
            unionDataSource.setMetadataFields(tmAction.getMetadataFields());
            return unionDataSource;
        }else {
            QueryAction action =actionList.get(0);
            DataSourceDTO dataSource = DataSourceDTOFactory.create(tmAction, action,key, dataSourceProcessors,false);
            return dataSource;
        }
    }

    public static  DataSourceDTO create(TmQueryAction tmAction, QueryAction action, String key , List<DataSourceProcessor> dataSourceProcessors, boolean isRoot){
        if (StringUtils.isEmpty(key) && tmAction != null){
            key = tmAction.getName();
        }
        DataSourceDTO dataSource =null;
        switch (action.getCategory()){
            case UiBotConstants.ACTION_CATEGORY_ESP:{
                DataSourceDTO espDataSource = new DataSourceDTO();
                espDataSource.setType(UiBotConstants.ACTION_CATEGORY_ESP);
                dataSource =  espDataSource;
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_TM:{
                if(action.getActionId().equals("sm_iqc.get.old") || action.getActionId().equals("sm_iqc.get.new")){
                    DataSourceDTO tmFormulaDataSource = new DataSourceDTO();
                    tmFormulaDataSource.setType(UiBotConstants.ACTION_CATEGORY_TM);
                    dataSource =  tmFormulaDataSource;
                }else if(action.getActionId().equals("athena_MechanismRecordGet")){
                    DataSourceDTO tmDataSource = new DataSourceDTO();
                    tmDataSource.setType(UiBotConstants.ACTION_CATEGORY_TM);
                    dataSource =  tmDataSource;
                }else if(action.getActionId().equals("athena_TimeIntervalCodeGet")){
                    DataSourceDTO tmDataSource = new DataSourceDTO();
                    tmDataSource.setType(UiBotConstants.ACTION_CATEGORY_TM);
                    dataSource =  tmDataSource;
                }
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_RAW_DATA:{
                DataSourceDTO rawDataSource = new DataSourceDTO();
                rawDataSource.setName(key);
                rawDataSource.setType(UiBotConstants.ACTION_CATEGORY_RAW_DATA);
                if (!org.springframework.util.CollectionUtils.isEmpty(action.getParas())) {
                    HashMap value = (HashMap) action.getParas();
                    rawDataSource.setRawData(value);
                }
                dataSource =  rawDataSource;
                break;
            }
            case UiBotConstants.ACTION_CATEGORY_SD:{
                DataSourceDTO sdDataSource = new DataSourceDTO();
                sdDataSource.setType(UiBotConstants.ACTION_CATEGORY_SD);
                dataSource =  sdDataSource;
                break;
            }
            default:{
                break;
            }
        }
        if (dataSource!=null){
            dataSource.setAction(action);
            dataSource.setActionId(tmAction.getActionId());//NOSONAR
            dataSource.setName(key);
            dataSource.setDataSourceProcessors(dataSourceProcessors);
            dataSource.setDataKeys(tmAction.getDataKeys());
            dataSource.setLimit(tmAction.getLimit());
            dataSource.setNotArray(tmAction.getNotArray());
            dataSource.setOverride(tmAction.getOverride());
        }
        //只有根节点才需要添加元数据
        if (isRoot){
            dataSource.setMetadataFields(tmAction.getMetadataFields());//NOSONAR
        }
        return dataSource;
    }
}
