package com.digiwin.athena.atdm.config;

import com.digiwin.athena.appcore.auth.RestTemplateAddTokenInterceptor;
import okhttp3.OkHttpClient;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RestTemplateOkHttpConfig {
    @Autowired
    RestTemplateAddTokenInterceptor restTemplateAddTokenInterceptor;

    @Bean
    public OkHttpClient sdkCommonOkHttpClient(){
        return  new OkHttpClient();
    }


    @Bean("okHttpRestTemplate")
    public RestTemplate okHttpRestTemplate(ObjectProvider<RestTemplateBuilder> restTemplateBuilder, OkHttpClient okHttpClient) {
        RestTemplate restTemplate = restTemplateBuilder.getIfAvailable()
                .interceptors(restTemplateAddTokenInterceptor)
                .requestFactory(()->{ return new OkHttp3ClientHttpRequestFactory(okHttpClient);})
                .build();

        return restTemplate;
    }

}
