package com.digiwin.athena.atdm.ptm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.util.List;
import java.util.Set;

/**
 * PtmWithdrawRespDTO Description
 *
 * @author majianfu
 * @date 2022/10/11
 * @since
 */
@Data
public class PtmWithdrawRespDTO {
    /**
     * 工作事项id
     */
    private Long workItemId;

    /**
     * 任务id列表
     */
    private Set<Long> taskIds;

    /**
     * 后置关联任务列表
     */
    private List<Task> nextWorkItems;

    /**
     * 工作事项的状态
     */
    private Integer state;

    @Data
    public static class Task {
        /**
         * 待办项ID
         */
        private Long workItemId;

        /**
         * 任务code
         */
        private String taskDefCode;

        /**
         * 项目code
         */
        private String projectDefCode;

        /**
         * 工作事项的状态
         */
        private Integer state;

        /**
         * 任务ID
         */
        private Long taskId;

        @JsonIgnore
        private Boolean inSameTask;
    }
}
