package com.digiwin.athena.atdm.util;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atdm.audc.dto.UserTrackExtendDTO;
import com.digiwin.athena.atdm.audc.CommonAudcService;
import com.jugg.agile.framework.core.util.concurrent.JaThreadPool;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 埋点工具类
 *
 * @author chenpeng
 */
@Slf4j
@Component
public class TrackingUtil {
    @Resource
    private CommonAudcService audcService;


    /**
     * 埋点
     */
    public void reportUserTrack(String workType, String code, String description) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        JaThreadPool.execute(() -> {
            List<UserTrackExtendDTO> requestParam = buildRequestParam(authoredUser, "function_analysis", workType, null, code, description);
            audcService.reportUserTrack(authoredUser, requestParam);
        });
    }

    /**
     * 组装请求参数
     *
     * @param authoredUser
     * @param source       performance_analysis:性能分析, function_analysis:功能分析, null:用户行为上报
     * @param workType     作业类型，如：任务 task， 项目：Project，报表：report，基础资料录入：base-data
     * @param appCode      应用code
     * @param code         任务code/页面唯一标识/作业唯一标识
     * @param description  描述
     * @return
     */
    private List<UserTrackExtendDTO> buildRequestParam(AuthoredUser authoredUser, String source, String workType, String appCode, String code, String description) {
        List<UserTrackExtendDTO> list = new ArrayList<>();
        UserTrackExtendDTO extendDTO = new UserTrackExtendDTO();
        extendDTO.setSource(source);
        extendDTO.setWorkType(workType);
        extendDTO.setWorkCode(code);
        extendDTO.setUserId(authoredUser.getUserId());
        extendDTO.setTenantId(authoredUser.getTenantId());
        Long createTime = LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        extendDTO.setTimestamp(createTime);
        Map<String, Object> workContent = new HashMap<>();
        workContent.put("code", code);
        workContent.put("description", description);
        Map<String, Object> attachData = new HashMap<>();
        attachData.put("appCode", appCode);
        extendDTO.setWorkContent(workContent);
        extendDTO.setAttachData(attachData);
        list.add(extendDTO);
        return list;
    }
}
