package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.domain.*;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import lombok.Data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class AtmcChangeDataSource extends DataSourceBase {

    private final static String PARA_NAME = "queryMap";

    public AtmcChangeDataSource( ){
        super();
        this.setType(UiBotConstants.ACTION_CATEGORY_ATMC_CHANGE);
    }

    /**
     * 查询数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @return
     */
    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo,List<Map> orderInfo,List<Map> searchInfo) {
        QueryAction action = this.getAction();
        if (action  == null || action.getParas()==null || !action.getParas().containsKey(PARA_NAME)){
            return  QueryResult.empty(this.getName());
        }

        List<Map> value = SpringUtil.getBean(CommonAtmcService.class).getChangeTaskDataSource((Map)action.getParas().get(PARA_NAME));
        List<Object> list = new ArrayList<>();
        if(value!=null) {
            value.forEach(m->{
                list.add(m);
            });
        }
        Map<String,List<Object>> espData = new HashMap<>();
        espData.put("response", list);
        QueryResult queryResult = QueryResult.withData( this.getName(),espData);
        return  queryResult;
    }


    /**
     * 附加数据的元数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @param queryResult    查询结果
     * @return
     */
    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext,  Map<String, Object> parameter, QueryResult queryResult) {
        //查询元数据
        ApiMetadataCollection apiMetadataCollection = ApiMetadataCollection.empty();

        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        AtmcChangeDataSource atmcDataSource = new AtmcChangeDataSource();
        atmcDataSource.setName(this.getName());
        atmcDataSource.setAction(this.getAction());
        atmcDataSource.setType(this.getType());
        atmcDataSource.setDataKeys(this.getDataKeys());
        atmcDataSource.setActionId(this.getActionId());
        return atmcDataSource;
    }
}
