package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;
import java.util.Map;

/**
 * 数据查询条件
 *
 * @Author hejy
 * @Version 1.0
 * @Date 2024/1/17 14:46
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class DataQuery {

    /**
     * 上下文
     */
    private ExecuteContext executeContext;

    /**
     * 直接参数
     */
    private Map<String, Object> parameter;

    /**
     * 分页条件
     */
    private PageInfo pageInfo;

    /**
     * 排序条件
     */
    List<Map> sortInfo;

    /**
     * 高级查询
     */
    List<Map> searchInfo;

    /**
     * 行数计算方式
     */
    private String rowSizeType;

}
