package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;

/**
 * 对定义的TM的元数据和获取的数据行数据做改造
 */
public interface DataSourceProcessService {


    /**
     * 对元数据处理
     * @param dataSourceProcessor 处理器
     * @param executeContext 执行上下文
     * @param dataSourceProcessor 数据处理器
     * @param dataSourceBase 查询的结果的数据
     * @param queryResult 查询结果
     */
    void handelMetadata( DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult);

    /**
     * 对数据处理
     * @param dataSourceProcessor 处理器
     */
    void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult);
}
