package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.datasource.domain.*;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.google.common.collect.Maps;
import lombok.Data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;


@Data
public class SdDataSource extends  DataSourceBase {

    public SdDataSource() {
        super();
        this.setType(UiBotConstants.ACTION_CATEGORY_SD);
    }


    /**
     * 查询数据
     *
     * @param executeContext 执行上下文
     * @param parameter      参数
     * @return
     */
    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo,List<Map> sortInfo,List<Map> searchInfo) {
        if (this.getAction() == null) {
            return QueryResult.empty(this.getName());
        }
        Map<String, Object> extendedFields = Maps.newHashMap();
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        HashMap<String,Object> response = SpringUtil.getBean(CommonSmartDataService.class).execute(executeContext.getAuthoredUser().getTenantId(), this.getAction().getActionId(), this.getAction().getParas(), executeContext.getBusinessUnit(), extendedFields);
        if (response == null) {
            return QueryResult.empty(this.getName());
        } else {
            //todo:数据源只能处理api返回的第一个数据，是否合理需要后续来看怎么处理。
            AtomicReference<QueryResult> queryResult = new AtomicReference<>();
            response.forEach((k, v) -> {
                //返回的数据源可能是集合也可能非集合
                if (v instanceof Collection) {
                    queryResult.set(QueryResult.withData(this.getName(), (List<Map<String, Object>>) v));
                } else if(v instanceof Map){
                    queryResult.set(QueryResult.withSingleData(this.getName(), (Map<String, Object>) v));
                }
                return;
            });
            if(queryResult.get()==null){
                //如果都不是，直接返加list的response
                if(response instanceof Collection){
                    queryResult.set(QueryResult.withData(this.getName(), (List<Map<String, Object>>) response));
                }else if(response instanceof Map){
                    List<Map<String, Object>> dataList= new ArrayList<>();
                    dataList.add(response);
                    queryResult.set(QueryResult.withData(this.getName(), dataList));
                }
            }
            return queryResult.get();
        }
    }

    /**
     * 附加数据的元数据
     *
     * @param executeContext   执行上下文
     * @param parameter        参数
     * @param queryResult      查询结果
     * @return
     */
    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext,  Map<String, Object> parameter, QueryResult queryResult) {
        //查询元数据
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        ApiMetadata apiMetadata =SpringUtil.getBean(CommonMetadataService.class).getMetadata(executeContext.getLocale(), this.getAction().getActionId());
//        if (masterMetadataDataDTO == null){
//            apiMetadataCollection = ApiMetadataCollection.empty();
//            apiMetadataCollection.getMasterApiMetadata().setActionId(this.getActionId());
//            return apiMetadataCollection ;
//        }
//        ApiMetadata apiMetadata = MetadataDataDTO2ApiMetadata.createApiMetadata(masterMetadataDataDTO);
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }


    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        SdDataSource sdDataSource = new SdDataSource();
        sdDataSource.setName(this.getName());
        sdDataSource.setAction(this.getAction());
        sdDataSource.setType(this.getType());
        sdDataSource.setDataKeys(this.getDataKeys());
        sdDataSource.setActionId(this.getActionId());
        return sdDataSource;
    }
}
