/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.activity.domain.AttachmentConfig;
import com.digiwin.athena.atdm.activity.domain.AttachmentConfigInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AttachmentUtil {
    public static boolean isPageCodeEnableAttachment(String pageCode) {
        return "task-detail".equals(pageCode) || "project-detail".equals(pageCode) || "basic-data".equals(pageCode);
    }

    public static boolean sourceTypeEnableAttachment(String type) {
        return !"SHELVED_DATA".equals(type);
    }

    public static List<String> getQueryCategories(AttachmentConfig attachmentConfigInfo) {
        if (null == attachmentConfigInfo) {
            return Collections.emptyList();
        }
        HashSet categories = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)attachmentConfigInfo.getUploadCategory())) {
            categories.add(attachmentConfigInfo.getUploadCategory());
        }
        if (ArrayUtils.isNotEmpty((Object[])attachmentConfigInfo.getReadCategory())) {
            categories.addAll(Arrays.asList(attachmentConfigInfo.getReadCategory()));
        }
        return Lists.newArrayList((Iterable)categories);
    }

    public static AttachmentConfigInfo toAttachment(Object param) {
        if (null == param) {
            return new AttachmentConfigInfo();
        }
        if (param instanceof AttachmentConfigInfo) {
            return (AttachmentConfigInfo)param;
        }
        return (AttachmentConfigInfo)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)param), AttachmentConfigInfo.class);
    }
}

