/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.datasource.BuildPageDataProcessService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="mergeData")
public class MergeProcessService
implements BuildPageDataProcessService {
    @Autowired
    private MessageUtils messageUtils;

    public void handelPageData(ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResultSet queryResultSet) {
        Map tmSignleMap;
        if (queryResultSet == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)queryResultSet.getQueryResults())) {
            return;
        }
        this.setMainQueryResult(queryResultSet);
        QueryResult itemsQueryResult = null;
        List itemsData = null;
        List themeMapdata = null;
        for (QueryResult result : queryResultSet.getQueryResults()) {
            if (!"data".equals(result.getDataSourceName())) continue;
            themeMapdata = result.getData();
            break;
        }
        List tmData = null;
        if (themeMapdata != null && themeMapdata.size() > 0 && (tmSignleMap = (Map)themeMapdata.get(0)).containsKey("data") && tmSignleMap.get("data") != null && (tmSignleMap = (Map)tmSignleMap.get("data")).containsKey("value")) {
            tmData = (List)tmSignleMap.get("value");
        }
        for (QueryResult result : queryResultSet.getQueryResults()) {
            itemsData = null;
            itemsQueryResult = null;
            if ("items_data".equals(result.getDataSourceName())) {
                itemsData = result.getData();
                itemsQueryResult = result;
            } else if ("items_data_forecast".equals(result.getDataSourceName())) {
                itemsData = result.getData();
                itemsQueryResult = result;
            } else if ("items_data_products".equals(result.getDataSourceName())) {
                itemsData = result.getData();
                itemsQueryResult = result;
            } else if ("items_data_products_industry".equals(result.getDataSourceName())) {
                itemsData = result.getData();
                itemsQueryResult = result;
            } else if ("items_data_products_unclassified".equals(result.getDataSourceName())) {
                itemsData = result.getData();
                itemsQueryResult = result;
            } else if ("items_data_semiproducts".equals(result.getDataSourceName())) {
                itemsData = result.getData();
                itemsQueryResult = result;
            } else if ("items_data_semiproducts_industry".equals(result.getDataSourceName())) {
                itemsData = result.getData();
                itemsQueryResult = result;
            } else if ("items_data_semiproducts_unclassified".equals(result.getDataSourceName())) {
                itemsData = result.getData();
                itemsQueryResult = result;
            }
            if (itemsData != null) {
                this.mergeData(itemsData, tmData);
            }
            if (itemsQueryResult == null) continue;
            this.handelMetadata(itemsQueryResult, executeContext.getIdentity(), executeContext.getTmActivityId());
        }
        if ("project-detail".equals(executeContext.getPageCode())) {
            this.unionData(queryResultSet);
        }
    }

    private void mergeData(List<Map<String, Object>> itemsData, List<Map<String, Object>> tmData) {
        String dataKey = "item_no";
        String typeKey = "inv_type";
        String adjustKey = "adjust_type";
        if (tmData == null) {
            for (Map<String, Object> item : itemsData) {
                if (item.containsKey("adoption_result")) continue;
                item.put("adoption_result", "");
            }
        } else {
            block1: for (Map<String, Object> item : itemsData) {
                if (!item.containsKey(dataKey) || !item.containsKey(typeKey)) continue;
                String dataKeyValue = (String)item.get(dataKey);
                String typeKeyValue = (String)item.get(typeKey);
                String adjustKeyValue = (String)item.get(adjustKey);
                for (Map<String, Object> tm : tmData) {
                    if (tm.containsKey(dataKey) && dataKeyValue.equals(tm.get(dataKey)) && tm.containsKey(typeKey) && typeKeyValue.equals(tm.get(typeKey)) && tm.containsKey(adjustKey) && adjustKeyValue.equals(tm.get(adjustKey))) {
                        for (String k : tm.keySet()) {
                            item.put(k, tm.get(k));
                        }
                        continue block1;
                    }
                    item.put("adoption_result", "");
                }
            }
        }
    }

    private void handelMetadata(QueryResult itemsQueryResult, String identity, String activityId) {
        ApiMetadataCollection apiMetadataCollection = itemsQueryResult.getApiMetadataCollection();
        if (apiMetadataCollection == null) {
            return;
        }
        ApiMetadata apiMetadata = apiMetadataCollection.getMasterApiMetadata();
        List metadataFieldList = ((MetadataField)apiMetadata.getResponseFields().get(0)).getSubFields();
        MetadataField atop = new MetadataField();
        atop.setName("adoption_result");
        atop.setRequired(true);
        atop.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.operation"));
        atop.setDataType("string");
        atop.setDataKey("false");
        metadataFieldList.add(atop);
        if ("performer".equals(identity) && "meteralStockMechanismSuggestion".equals(activityId)) {
            atop.setCanEdit(true);
            for (MetadataField field : metadataFieldList) {
                if (!"new_purchase_interval_days".equals(field.getName())) continue;
                field.setCanEdit(true);
                break;
            }
        }
    }

    private void unionData(QueryResultSet queryResultSet) {
        String[] dataKeyNames;
        List resultList = queryResultSet.getQueryResults();
        List itemsData = null;
        for (QueryResult result : resultList) {
            if (!"items_data".equals(result.getDataSourceName())) continue;
            itemsData = result.getData();
            queryResultSet.setMainQueryResult(result);
            break;
        }
        for (QueryResult result : resultList) {
            if ("items_data_forecast".equals(result.getDataSourceName())) {
                itemsData.addAll(result.getData());
                continue;
            }
            if ("items_data_products".equals(result.getDataSourceName())) {
                itemsData.addAll(result.getData());
                continue;
            }
            if ("items_data_products_industry".equals(result.getDataSourceName())) {
                itemsData.addAll(result.getData());
                continue;
            }
            if ("items_data_products_unclassified".equals(result.getDataSourceName())) {
                itemsData.addAll(result.getData());
                continue;
            }
            if ("items_data_semiproducts".equals(result.getDataSourceName())) {
                itemsData.addAll(result.getData());
                continue;
            }
            if ("items_data_semiproducts_industry".equals(result.getDataSourceName())) {
                itemsData.addAll(result.getData());
                continue;
            }
            if (!"items_data_semiproducts_unclassified".equals(result.getDataSourceName())) continue;
            itemsData.addAll(result.getData());
        }
        for (String dataKey : dataKeyNames = new String[]{"items_data_forecast", "items_data_products", "items_data_products_industry", "items_data_products_unclassified", "items_data_semiproducts", "items_data_semiproducts_industry", "items_data_semiproducts_unclassified", "inv_data", "inv_data_products", "inv_data_semiproducts", "data"}) {
            Optional<QueryResult> result = resultList.stream().filter(x -> x.getDataSourceName().equals(dataKey)).findFirst();
            if (!result.isPresent()) continue;
            resultList.remove(result.get());
        }
    }

    private void setMainQueryResult(QueryResultSet queryResultSet) {
        String[] dataKeyNames;
        List resultList = queryResultSet.getQueryResults();
        for (String dataKey : dataKeyNames = new String[]{"items_data", "items_data_forecast", "items_data_products", "items_data_products_industry", "items_data_products_unclassified", "items_data_semiproducts", "items_data_semiproducts_industry", "items_data_semiproducts_unclassified"}) {
            Optional<QueryResult> result = resultList.stream().filter(x -> x.getDataSourceName().equals(dataKey)).findFirst();
            if (!result.isPresent() || !CollectionUtils.isNotEmpty((Collection)result.get().getData())) continue;
            queryResultSet.setMainQueryResult(result.get());
        }
    }
}

