package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.cache.CacheManager;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atdm.activity.ActivityConstants;
import com.digiwin.athena.atdm.constant.AtdmCacheConstants;
import com.digiwin.athena.atdm.datasource.BuildPageDataProcessService;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.esp.CommonESPService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.Duration;
import java.util.HashMap;

@Slf4j
@Service("appendGlobalParameterService")
public class AppendGlobalParameterService implements BuildPageDataProcessService {
    @Autowired
    private CommonESPService commonEspService;

    @Autowired
    private CacheManager cacheManager;

    @Override
    public void handelPageData(ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResultSet queryResultSet) {
        if (!ActivityConstants.TASK_DETAIL.equals(executeContext.getPageCode()) && !ActivityConstants.PROJECT_DETAIL.equals(executeContext.getPageCode())) {
            return;
        }
        if (queryResultSet == null) {
            return;
        }
        if (CollectionUtils.isEmpty(queryResultSet.getQueryResults())) {
            return;
        }
        try {
            String cacheKey = executeContext.getTenantId() + ":system.parameter.data.get";
            String json = (String) cacheManager.get(AtdmCacheConstants.CACHE_KEY_PREFIX, cacheKey);
            if (json != null) {
                HashMap params = JsonUtils.jsonToObject(json, HashMap.class);
                QueryResult queryResult = QueryResult.withSingleData("uibot__global_parameter", params);
                queryResultSet.appendData(queryResult);
            } else {
                HashMap params = commonEspService.queryByApiName(executeContext, "system.parameter.data.get", null, null, null, null);
                if (params == null || MapUtils.isEmpty(params) || params.containsKey("")) {
                    return;
                }
                cacheManager.cache(AtdmCacheConstants.CACHE_KEY_PREFIX, cacheKey, JsonUtils.objectToString(params), Duration.ofMinutes(30));
                QueryResult queryResult = QueryResult.withSingleData("uibot__global_parameter", params);
                queryResultSet.appendData(queryResult);
            }
        } catch (Exception ex) {
            //吃掉异常，不能影响界面的显示
            log.error(ex.getMessage(), ex);
        }

    }

}
