package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.ScriptEngineUtils;
import com.digiwin.athena.atdm.activity.ActivityConstants;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.*;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("checkItemService")
public class CheckItemsServiceSource implements DataSourceProcessService {
    @Autowired
    private MessageUtils messageUtils;

    /**
     * 对元数据处理
     *
     * @param dataSourceBase      查询的结果的数据
     * @param executeContext      执行上下文
     * @param dataSourceProcessor 处理器
     * @param queryResult         查询结果
     */
    @Override
    public void handelMetadata( DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
//        addCheckItemFiled(queryResult.getApiMetadataCollection(), executeContext.getPageCode());
    }

    /**
     * 对数据处理
     *
     * @param dataSourceBase
     * @param executeContext
     * @param dataSourceProcessor 处理器
     * @param queryResult
     */
    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
    }


    /**
     * 添加CHECK-ITEM 数据
     *
     * @param checkItems
     * @param apiData
     */
    private void addCheckItemsData(List<CheckItem> checkItems, List<Map<String, Object>> apiData) {
        if (CollectionUtils.isEmpty(apiData)) {
            return;
        }
        for (Map<String, Object> datum : apiData) {
            List<Map<String, Object>> checkDataList = new ArrayList<>();
            for (CheckItem checkItem : checkItems) {
                Map<String, Object> checkData = new HashMap<>();
                checkData.put("key", checkItem.getKey());
                checkData.put("name", checkItem.getName());
                if (StringUtils.hasText(checkItem.getScript())) {
                    if ("true".equals(checkItem.getScript())){
                        checkData.put("yesOrNo", false);
                    }else  if ("false".equals(checkItem.getScript())){
                        checkData.put("yesOrNo", true);
                    }else {
                        Object checkValue = ScriptEngineUtils.getInstance().evalScript(checkItem.getScript(), datum);
                        checkData.put("yesOrNo", !((Boolean) checkValue));
                    }
                } else if (datum.containsKey(checkItem.getKey())) {
                    Object checkValue = datum.get(checkItem.getKey());
                    checkData.put("yesOrNo", !((Boolean) checkValue));
                } else {
                    checkData.put("yesOrNo", false);
                }
                if (datum.containsKey(checkItem.getStandardValue())) {
                    checkData.put("standardValue", datum.get(checkItem.getStandardValue()));
                }
                if (datum.containsKey(checkItem.getValue())) {
                    checkData.put("value", datum.get(checkItem.getValue()));
                }
                checkDataList.add(checkData);
            }
            datum.put("check_result", checkDataList);
        }
    }

    /**
     * 添加CHECK-ITEM 字段
     *
     * @param apiMetadataCollection
     */
    private void addCheckItemFiled(ApiMetadataCollection apiMetadataCollection, String pageCode) {
        //在主数据的metadata上增加一个字段
        if(apiMetadataCollection == null){
            return;
        }
        MetadataField metadataField = new MetadataField();
        metadataField.setArray(true);
        metadataField.setUiBot("Y");
        metadataField.setName("check_result");
        if (ActivityConstants.PROJECT_DETAIL.equals(pageCode)) {
//            Set<String> fieldTags = new HashSet<>();
//            fieldTags.add("check_result");
//            fieldTags.add("ORDER_999");
//            metadataField.setFieldTags(fieldTags);
            metadataField.setTagDefinitions(CustomizeTagUtils.createOrderTagDefinitions("999"));
        }
        metadataField.setDescription(messageUtils.getMessage("uibot.acitivity.check.title"));
        metadataField.setDataType("object");
        List<MetadataField> subFields = new ArrayList<>();
        MetadataField keyMetadataField = new MetadataField();
        keyMetadataField.setUiBot("Y");
        keyMetadataField.setArray(false);
        keyMetadataField.setName("key");
        keyMetadataField.setDataType("string");
        subFields.add(keyMetadataField);
        MetadataField valueMetadataField = new MetadataField();
        valueMetadataField.setArray(false);
        valueMetadataField.setUiBot("Y");
        valueMetadataField.setName("value");
        valueMetadataField.setDataType("string");
        subFields.add(valueMetadataField);
        MetadataField nameMetadataField = new MetadataField();
        nameMetadataField.setArray(false);
        nameMetadataField.setUiBot("Y");
        nameMetadataField.setName("name");
        nameMetadataField.setDataType("string");
        subFields.add(nameMetadataField);
        MetadataField yesOrNoMetadataField = new MetadataField();
        yesOrNoMetadataField.setArray(false);
        yesOrNoMetadataField.setUiBot("Y");
        yesOrNoMetadataField.setName("yesOrNo");
        yesOrNoMetadataField.setDataType("boolean");
        subFields.add(yesOrNoMetadataField);
        MetadataField standardValueMetadataField = new MetadataField();
        standardValueMetadataField.setArray(false);
        standardValueMetadataField.setUiBot("Y");
        standardValueMetadataField.setName("standardValue");
        standardValueMetadataField.setDataType("string");
        subFields.add(standardValueMetadataField);
        metadataField.setSubFields(subFields);
        //todo：暂时放在第一个字段上
        if(apiMetadataCollection.getMasterApiMetadata()!=null && CollectionUtils.isNotEmpty(apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {
            apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0).getSubFields().add(metadataField);
        }

    }
}

