/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataQuery;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.domain.ActionParameterMapping;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.thememap.CommonThemeMapService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.support.DefaultConversionService;

public abstract class DataSourceBase {
    private DefaultConversionService defaultConversionService = new DefaultConversionService();
    private String name;
    private List<String> dataKeys;
    private String type;
    private String actionId;
    private QueryAction action;
    private Integer limit;
    private Boolean single;
    private List<MetadataField> metadataFields;
    List<DataSourceProcessor> dataSourceProcessors;
    private HashMap<String, Object> extendedData;

    public QueryResult queryWithMetaData(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        QueryResult queryResult = this.query(executeContext, parameter, pageInfo, sortInfo, searchInfo);
        this.queryMetaData(executeContext, parameter, queryResult);
        return queryResult;
    }

    public QueryResult query(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        this.processParameter(parameter, executeContext);
        QueryResult queryResult = this.queryCore(executeContext, parameter, pageInfo, sortInfo, searchInfo);
        if (this.single != null && this.single.booleanValue()) {
            queryResult.setSingle(true);
            this.limit = 1;
        }
        if (this.limit != null && this.limit > 0) {
            queryResult.setLimit(this.limit);
        }
        queryResult.setDataKeys(this.dataKeys);
        queryResult.initializeDataKey();
        this.invokeDataProcessor(executeContext, parameter, queryResult);
        if (this.limit != null && this.limit > 0 && queryResult.getLimit() != null && queryResult.size() != queryResult.getLimit().intValue()) {
            queryResult.setLimit(this.limit);
            queryResult.setDataKeys(this.dataKeys);
            queryResult.initializeDataKey();
        }
        return queryResult;
    }

    @Deprecated
    public int size(ExecuteContext executeContext, Map<String, Object> parameter, String sizeType) {
        return this.size(DataQuery.builder().executeContext(executeContext).parameter(parameter).rowSizeType(sizeType).build());
    }

    public int size(DataQuery dataQuery) {
        this.processParameter(dataQuery.getParameter(), dataQuery.getExecuteContext());
        QueryResult queryResult = this.query(dataQuery.getExecuteContext(), dataQuery.getParameter(), dataQuery.getPageInfo(), dataQuery.getSortInfo(), dataQuery.getSearchInfo());
        if (this.limit != null) {
            queryResult.setLimit(this.limit);
        }
        if (queryResult.isHasNext()) {
            return queryResult.getTotalResults();
        }
        if ("byDataKey".equals(dataQuery.getRowSizeType())) {
            return queryResult.keySize();
        }
        return queryResult.size();
    }

    public Map<String, Integer> getDataSize(ExecuteContext executeContext, Map<String, Object> parameter, String sizeType) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        this.processParameter(parameter, executeContext);
        QueryResult queryResult = this.query(executeContext, parameter, null, null, null);
        if (this.limit != null) {
            queryResult.setLimit(this.limit);
        }
        if ("byDataKey".equals(sizeType)) {
            resultMap.put("size", queryResult.keySize());
            resultMap.put("abnormalSize", queryResult.getAbnormalDataKeyIndexSize());
        } else {
            resultMap.put("size", queryResult.size());
            resultMap.put("abnormalSize", queryResult.getAbnormalDataSize());
        }
        return resultMap;
    }

    protected void processParameter(Map<String, Object> parameter, ExecuteContext executeContext) {
        if (null == this.getAction()) {
            return;
        }
        if (this.getAction().getParas() == null) {
            this.getAction().setParas(new HashMap());
        }
        QueryResult queryResult = new QueryResult();
        queryResult.setData(new ArrayList());
        ApiMetadataCollection apiMetadataCollection = this.queryMetaDataCore(executeContext, parameter, queryResult);
        ArrayList<MetadataField> requestFields = new ArrayList();
        if (apiMetadataCollection != null && apiMetadataCollection.getMasterApiMetadata() != null) {
            requestFields = apiMetadataCollection.getMasterApiMetadata().getRequestFields();
        }
        if (parameter != null) {
            if (CollectionUtils.isEmpty((Collection)this.getAction().getActionParams())) {
                for (Map.Entry<String, Object> stringObjectEntry : parameter.entrySet()) {
                    this.getAction().getParas().put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                }
            } else {
                Map realParas = this.getAction().getParas();
                for (ActionParameterMapping actionParam : this.getAction().getActionParams()) {
                    Object o;
                    HashMap<String, Object> paraData;
                    JSONObject pJson;
                    Object pJsonArray;
                    Object pJson2;
                    Object p;
                    String[] conNames;
                    String conName;
                    Object paramValue;
                    if ("TM_VARIABLE".equals(actionParam.getType())) {
                        if (StringUtils.isNotBlank((CharSequence)actionParam.getValue())) {
                            String tenantId = null != executeContext.getAuthoredUser() ? executeContext.getAuthoredUser().getTenantId() : executeContext.getTenantId();
                            Object value = ((CommonThemeMapService)SpringUtil.getBean(CommonThemeMapService.class)).queryVariable(tenantId, executeContext.getLocale(), actionParam.getValue());
                            actionParam.setValue(null != value ? String.valueOf(value) : null);
                        }
                        actionParam.setType("CONSTANT");
                    }
                    if ("ACTIVE_ROW".equals(actionParam.getType())) {
                        paramValue = parameter.get(actionParam.getValue());
                        if (actionParam.getTypeConverter() != null) {
                            if ("stringToBooleanConverter".equals(actionParam.getTypeConverter())) {
                                paramValue = this.defaultConversionService.convert((Object)paramValue.toString(), Boolean.TYPE);
                            } else if ("stringToNumberConverter".equals(actionParam.getTypeConverter())) {
                                paramValue = this.defaultConversionService.convert((Object)paramValue.toString(), Integer.TYPE);
                            }
                        }
                        if ((conName = actionParam.getName()).contains(".")) {
                            conNames = conName.split("\\.");
                            p = realParas.get(conNames[0]);
                            if (p != null) {
                                Object paraData2;
                                if (p instanceof JSONObject) {
                                    pJson2 = (JSONObject)p;
                                    pJson2.put((Object)conNames[1], paramValue);
                                    continue;
                                }
                                if (p instanceof Map) {
                                    pJson2 = (Map)p;
                                    pJson2.put(conNames[1], paramValue);
                                    continue;
                                }
                                if (p instanceof JSONArray) {
                                    pJsonArray = (JSONArray)p;
                                    for (Object oJson : pJsonArray.toArray()) {
                                        if (!(oJson instanceof JSONObject)) continue;
                                        pJson = (JSONObject)oJson;
                                        pJson.put((Object)conNames[1], paramValue);
                                    }
                                    continue;
                                }
                                if (!(p instanceof List)) continue;
                                pJsonArray = (List)p;
                                if (pJsonArray.size() == 0) {
                                    paraData2 = new HashMap();
                                    if (paramValue == null) continue;
                                    paraData2.put(conNames[1], paramValue);
                                    pJsonArray.add(paraData2);
                                    continue;
                                }
                                paraData2 = pJsonArray.iterator();
                                while (paraData2.hasNext()) {
                                    Object o2 = paraData2.next();
                                    if (!(o2 instanceof Map)) continue;
                                    Map pJson3 = (Map)o2;
                                    if (paramValue == null) continue;
                                    pJson3.put(conNames[1], paramValue);
                                }
                                continue;
                            }
                            paraData = new HashMap<String, Object>();
                            if (paramValue != null) {
                                paraData.put(conNames[1], paramValue);
                            }
                            if (!this.requestIsArray(requestFields, conNames[0])) {
                                realParas.put(conNames[0], paraData);
                                continue;
                            }
                            o = new ArrayList();
                            if (MapUtils.isNotEmpty(paraData)) {
                                o.add(paraData);
                            }
                            realParas.put(conNames[0], o);
                            continue;
                        }
                        realParas.put(actionParam.getName(), paramValue);
                        continue;
                    }
                    if (!"ACTIVE_ROW_CONSTANT".equals(actionParam.getType()) && !"CONSTANT".equals(actionParam.getType())) continue;
                    paramValue = actionParam.getValue();
                    if (actionParam.getTypeConverter() != null) {
                        if ("stringToBooleanConverter".equals(actionParam.getTypeConverter())) {
                            paramValue = this.defaultConversionService.convert((Object)paramValue.toString(), Boolean.TYPE);
                        } else if ("stringToNumberConverter".equals(actionParam.getTypeConverter())) {
                            paramValue = this.defaultConversionService.convert((Object)paramValue.toString(), Integer.TYPE);
                        }
                    }
                    if ((conName = actionParam.getName()).contains(".")) {
                        conNames = conName.split("\\.");
                        p = realParas.get(conNames[0]);
                        if (p != null) {
                            if (p instanceof JSONObject) {
                                pJson2 = (JSONObject)p;
                                pJson2.put((Object)conNames[1], paramValue);
                                continue;
                            }
                            if (p instanceof Map) {
                                pJson2 = (Map)p;
                                pJson2.put(conNames[1], paramValue);
                                continue;
                            }
                            if (p instanceof JSONArray) {
                                pJsonArray = (JSONArray)p;
                                for (Object oJson : pJsonArray.toArray()) {
                                    if (!(oJson instanceof JSONObject)) continue;
                                    pJson = (JSONObject)oJson;
                                    pJson.put((Object)conNames[1], paramValue);
                                }
                                continue;
                            }
                            if (!(p instanceof List)) continue;
                            pJsonArray = (List)p;
                            o = pJsonArray.iterator();
                            while (o.hasNext()) {
                                Object o3 = o.next();
                                if (!(o3 instanceof Map)) continue;
                                Map pJson4 = (Map)o3;
                                pJson4.put(conNames[1], paramValue);
                            }
                            continue;
                        }
                        paraData = new HashMap();
                        paraData.put(conNames[1], paramValue);
                        if (!this.requestIsArray(requestFields, conNames[0])) {
                            realParas.put(conNames[0], paraData);
                            continue;
                        }
                        o = new ArrayList();
                        o.add(paraData);
                        realParas.put(conNames[0], o);
                        continue;
                    }
                    realParas.put(actionParam.getName(), paramValue);
                }
            }
        } else {
            if (MapUtils.isEmpty((Map)this.getAction().getParas())) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)this.getAction().getActionParams()) || this.getAction().getActionParams().size() == 0) {
                return;
            }
            Map realParas = this.getAction().getParas();
            String conNames = ((ActionParameterMapping)this.getAction().getActionParams().get(0)).getName();
            if (conNames.contains(".")) {
                conNames = conNames.split("\\.")[0];
            }
            if (!this.requestIsArray(requestFields, conNames)) {
                if (!(realParas.get(conNames) instanceof List)) {
                    return;
                }
                List paras = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(realParas.get(conNames)), Map.class);
                if (paras instanceof List && paras.size() > 0) {
                    Map parasMapOne = (Map)JsonUtils.jsonToListObject((String)JsonUtils.objectToString(realParas.get(conNames)), Map.class).get(0);
                    this.getAction().getParas().put(conNames, parasMapOne);
                }
            }
        }
    }

    private boolean requestIsArray(List<MetadataField> requestFields, String conNames) {
        if (CollectionUtils.isNotEmpty(requestFields)) {
            for (MetadataField metadataField : requestFields) {
                if (!conNames.equals(metadataField.getName()) || !"object".equals(metadataField.getDataType())) continue;
                return BooleanUtils.isTrue((Boolean)metadataField.getArray());
            }
        }
        return true;
    }

    protected void invokeMetaDataProcessor(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        if (CollectionUtils.isNotEmpty(this.dataSourceProcessors)) {
            for (DataSourceProcessor dataSourceProcessor : this.dataSourceProcessors) {
                DataSourceProcessService processService;
                if (StringUtils.isBlank((CharSequence)dataSourceProcessor.getServiceName()) || !"service".equals(dataSourceProcessor.getType()) || (processService = (DataSourceProcessService)SpringUtil.tryGetBean((String)dataSourceProcessor.getServiceName())) == null) continue;
                processService.handelMetadata(this, executeContext, dataSourceProcessor, queryResult);
            }
        }
    }

    protected void invokeDataProcessor(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        if (CollectionUtils.isNotEmpty(this.dataSourceProcessors)) {
            for (DataSourceProcessor dataSourceProcessor : this.dataSourceProcessors) {
                DataSourceProcessService processService;
                if (StringUtils.isBlank((CharSequence)dataSourceProcessor.getServiceName()) || "executeCompleted".equals(dataSourceProcessor.getActivePoint()) || !"service".equals(dataSourceProcessor.getType()) || (processService = (DataSourceProcessService)SpringUtil.tryGetBean((String)dataSourceProcessor.getServiceName())) == null) continue;
                processService.handelData(this, executeContext, dataSourceProcessor, queryResult);
            }
        }
    }

    protected abstract QueryResult queryCore(ExecuteContext var1, Map<String, Object> var2, PageInfo var3, List<Map> var4, List<Map> var5);

    protected ApiMetadataCollection queryMetaData(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = this.queryMetaDataCore(executeContext, parameter, queryResult);
        if (apiMetadataCollection == null) {
            return null;
        }
        if (queryResult != null) {
            queryResult.withMetaData(apiMetadataCollection);
            this.invokeMetaDataProcessor(executeContext, parameter, queryResult);
            if (this.metadataFields != null) {
                if (queryResult.getApiMetadataCollection().getMasterApiMetadata() == null) {
                    queryResult.getApiMetadataCollection().setMasterApiMetadata(new ApiMetadata());
                }
                queryResult.getApiMetadataCollection().getMasterApiMetadata().addVirtuallyResponseFields(this.metadataFields);
            }
            if (this.single != null && this.single.booleanValue()) {
                this.limit = 1;
                queryResult.setLimit(Integer.valueOf(1));
                if (CollectionUtils.isNotEmpty((Collection)queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields())) {
                    ((MetadataField)queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().get(0)).setArray(Boolean.valueOf(false));
                }
            }
            if (this.single == null && apiMetadataCollection.getMasterApiMetadata() != null && CollectionUtils.isNotEmpty((Collection)apiMetadataCollection.getMasterApiMetadata().getResponseFields()) && apiMetadataCollection.getMasterApiMetadata().getResponseFields().size() > 0) {
                MetadataField metadataField = (MetadataField)apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0);
                this.single = !BooleanUtils.isTrue((Boolean)metadataField.getArray());
                queryResult.setSingle(this.single.booleanValue());
            }
        }
        return apiMetadataCollection;
    }

    protected abstract ApiMetadataCollection queryMetaDataCore(ExecuteContext var1, Map<String, Object> var2, QueryResult var3);

    public DataSourceBase copyWithoutProcessor() {
        return this.copyWithoutProcessorCore();
    }

    protected abstract DataSourceBase copyWithoutProcessorCore();

    @Generated
    public DataSourceBase() {
    }

    @Generated
    public DefaultConversionService getDefaultConversionService() {
        return this.defaultConversionService;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getDataKeys() {
        return this.dataKeys;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getActionId() {
        return this.actionId;
    }

    @Generated
    public QueryAction getAction() {
        return this.action;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public Boolean getSingle() {
        return this.single;
    }

    @Generated
    public List<MetadataField> getMetadataFields() {
        return this.metadataFields;
    }

    @Generated
    public List<DataSourceProcessor> getDataSourceProcessors() {
        return this.dataSourceProcessors;
    }

    @Generated
    public HashMap<String, Object> getExtendedData() {
        return this.extendedData;
    }

    @Generated
    public void setDefaultConversionService(DefaultConversionService defaultConversionService) {
        this.defaultConversionService = defaultConversionService;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDataKeys(List<String> dataKeys) {
        this.dataKeys = dataKeys;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    @Generated
    public void setAction(QueryAction action) {
        this.action = action;
    }

    @Generated
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Generated
    public void setSingle(Boolean single) {
        this.single = single;
    }

    @Generated
    public void setMetadataFields(List<MetadataField> metadataFields) {
        this.metadataFields = metadataFields;
    }

    @Generated
    public void setDataSourceProcessors(List<DataSourceProcessor> dataSourceProcessors) {
        this.dataSourceProcessors = dataSourceProcessors;
    }

    @Generated
    public void setExtendedData(HashMap<String, Object> extendedData) {
        this.extendedData = extendedData;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceBase)) {
            return false;
        }
        DataSourceBase other = (DataSourceBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Boolean this$single = this.getSingle();
        Boolean other$single = other.getSingle();
        if (this$single == null ? other$single != null : !((Object)this$single).equals(other$single)) {
            return false;
        }
        DefaultConversionService this$defaultConversionService = this.getDefaultConversionService();
        DefaultConversionService other$defaultConversionService = other.getDefaultConversionService();
        if (this$defaultConversionService == null ? other$defaultConversionService != null : !this$defaultConversionService.equals(other$defaultConversionService)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$dataKeys = this.getDataKeys();
        List<String> other$dataKeys = other.getDataKeys();
        if (this$dataKeys == null ? other$dataKeys != null : !((Object)this$dataKeys).equals(other$dataKeys)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$actionId = this.getActionId();
        String other$actionId = other.getActionId();
        if (this$actionId == null ? other$actionId != null : !this$actionId.equals(other$actionId)) {
            return false;
        }
        QueryAction this$action = this.getAction();
        QueryAction other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        List<MetadataField> this$metadataFields = this.getMetadataFields();
        List<MetadataField> other$metadataFields = other.getMetadataFields();
        if (this$metadataFields == null ? other$metadataFields != null : !((Object)this$metadataFields).equals(other$metadataFields)) {
            return false;
        }
        List<DataSourceProcessor> this$dataSourceProcessors = this.getDataSourceProcessors();
        List<DataSourceProcessor> other$dataSourceProcessors = other.getDataSourceProcessors();
        if (this$dataSourceProcessors == null ? other$dataSourceProcessors != null : !((Object)this$dataSourceProcessors).equals(other$dataSourceProcessors)) {
            return false;
        }
        HashMap<String, Object> this$extendedData = this.getExtendedData();
        HashMap<String, Object> other$extendedData = other.getExtendedData();
        return !(this$extendedData == null ? other$extendedData != null : !((Object)this$extendedData).equals(other$extendedData));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataSourceBase;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Boolean $single = this.getSingle();
        result = result * 59 + ($single == null ? 43 : ((Object)$single).hashCode());
        DefaultConversionService $defaultConversionService = this.getDefaultConversionService();
        result = result * 59 + ($defaultConversionService == null ? 43 : $defaultConversionService.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $dataKeys = this.getDataKeys();
        result = result * 59 + ($dataKeys == null ? 43 : ((Object)$dataKeys).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $actionId = this.getActionId();
        result = result * 59 + ($actionId == null ? 43 : $actionId.hashCode());
        QueryAction $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        List<MetadataField> $metadataFields = this.getMetadataFields();
        result = result * 59 + ($metadataFields == null ? 43 : ((Object)$metadataFields).hashCode());
        List<DataSourceProcessor> $dataSourceProcessors = this.getDataSourceProcessors();
        result = result * 59 + ($dataSourceProcessors == null ? 43 : ((Object)$dataSourceProcessors).hashCode());
        HashMap<String, Object> $extendedData = this.getExtendedData();
        result = result * 59 + ($extendedData == null ? 43 : ((Object)$extendedData).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DataSourceBase(defaultConversionService=" + this.getDefaultConversionService() + ", name=" + this.getName() + ", dataKeys=" + this.getDataKeys() + ", type=" + this.getType() + ", actionId=" + this.getActionId() + ", action=" + this.getAction() + ", limit=" + this.getLimit() + ", single=" + this.getSingle() + ", metadataFields=" + this.getMetadataFields() + ", dataSourceProcessors=" + this.getDataSourceProcessors() + ", extendedData=" + this.getExtendedData() + ")";
    }
}

