/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.datasource.DataQuery;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.ParallelQueryTaskUtils;
import com.digiwin.athena.atdm.datasource.datasource.RawDataSource;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionDataSource
extends DataSourceBase {
    private static Logger logger = LoggerFactory.getLogger(UnionDataSource.class);
    private Boolean mergeQuery;
    private List<DataSourceBase> unionItems;

    @Override
    public QueryAction getAction() {
        if (CollectionUtils.isEmpty(this.unionItems)) {
            return null;
        }
        return this.unionItems.get(0).getAction();
    }

    @Override
    public String getActionId() {
        if (this.getAction() != null) {
            return this.getAction().getActionId();
        }
        return "";
    }

    public UnionDataSource() {
        this.setType("MIX_UNION");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (CollectionUtils.isEmpty(this.unionItems)) {
            return QueryResult.empty((String)this.getName());
        }
        if (this.mergeQuery != null && this.mergeQuery.booleanValue()) {
            this.mergeQuery();
        }
        QueryResult result = this.unionItems.get(0).query(executeContext, parameter, pageInfo, sortInfo, searchInfo);
        result.setDataSourceName(this.getName());
        if (this.unionItems.size() >= 2) {
            if (this.unionItems.size() == 2) {
                QueryResult nextResult = this.unionItems.get(1).query(executeContext, parameter, pageInfo, sortInfo, searchInfo);
                if (CollectionUtils.isNotEmpty((Collection)nextResult.getData())) {
                    result.appendData(nextResult);
                }
            } else {
                List<QueryResult> results = null;
                try {
                    results = ParallelQueryTaskUtils.query(executeContext, parameter, this.unionItems.subList(1, this.unionItems.size()), pageInfo, sortInfo, searchInfo);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    if (e.getCause() instanceof BusinessException) {
                        throw (BusinessException)e.getCause();
                    }
                    logger.error("\u591a\u7ebf\u7a0b\u5904\u7406\u51fa\u95ee\u9898\uff1a" + e.getMessage());
                    throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0045.getErrCode(), (String)"\u591a\u7ebf\u7a0b\u5904\u7406\u51fa\u95ee\u9898", (Throwable)e);
                }
                for (QueryResult queryResult : results) {
                    if (!CollectionUtils.isNotEmpty((Collection)queryResult.getData())) continue;
                    result.appendData(queryResult);
                }
            }
        }
        return result;
    }

    @Override
    @Deprecated
    public int size(ExecuteContext executeContext, Map<String, Object> parameter, String sizeType) {
        if (this.unionItems != null && this.unionItems.size() > 0 && "ESP".equals(this.unionItems.get(0).getType())) {
            this.mergeQuery();
        }
        return super.size(executeContext, parameter, sizeType);
    }

    @Override
    public int size(DataQuery dataQuery) {
        if (CollectionUtils.isNotEmpty(this.unionItems) && "ESP".equals(this.unionItems.get(0).getType())) {
            this.mergeQuery();
        }
        return super.size(dataQuery);
    }

    private void mergeQuery() {
        if (this.unionItems != null && this.unionItems.size() > 1) {
            Map<String, List<DataSourceBase>> groupDs = this.unionItems.stream().filter(e -> {
                if (Objects.isNull(e.getAction())) {
                    return true;
                }
                return BooleanUtils.isNotFalse((Boolean)e.getAction().getQueryData());
            }).collect(Collectors.groupingBy(e -> StringUtils.isNotBlank((CharSequence)e.getActionId()) ? e.getActionId() : "UIBOT_NULL_ACTION_ID"));
            this.unionItems.clear();
            for (List<DataSourceBase> dataSourceBaseList : groupDs.values()) {
                Map firstParas;
                if (dataSourceBaseList.size() == 1) {
                    this.unionItems.add(dataSourceBaseList.get(0));
                    continue;
                }
                if (!this.businessUnitIsSame(dataSourceBaseList)) {
                    this.unionItems.addAll(dataSourceBaseList);
                    continue;
                }
                DataSourceBase first = dataSourceBaseList.get(0);
                if (first.getAction() == null) continue;
                if (first instanceof RawDataSource) {
                    this.merge(dataSourceBaseList);
                }
                if ((firstParas = first.getAction().getParas()) == null) {
                    this.unionItems.add(first);
                    continue;
                }
                for (Object key : firstParas.keySet()) {
                    Object firstParaValue = firstParas.get(key);
                    if (!(firstParaValue instanceof Collection)) continue;
                    Collection firstParaValueCollection = (Collection)firstParaValue;
                    for (int i = 1; i < dataSourceBaseList.size(); ++i) {
                        DataSourceBase dataSourceBase = dataSourceBaseList.get(i);
                        if (dataSourceBase.getAction() == null || !MapUtils.isNotEmpty((Map)dataSourceBase.getAction().getParas())) continue;
                        Map paras = dataSourceBase.getAction().getParas();
                        if (paras.containsKey(key)) {
                            firstParaValueCollection.addAll((Collection)paras.get(key));
                        }
                        if (dataSourceBase.getLimit() == null) continue;
                        if (first.getLimit() == null) {
                            first.setLimit(0);
                        }
                        first.setLimit(first.getLimit() + dataSourceBase.getLimit());
                    }
                }
                this.unionItems.add(first);
            }
        }
    }

    private void merge(List<DataSourceBase> dataSourceBaseList) {
        DataSourceBase first = dataSourceBaseList.get(0);
        int hasRawDataIndex = 0;
        HashMap<String, Object> rawData = null;
        for (int i = 0; i < dataSourceBaseList.size(); ++i) {
            HashMap<String, Object> hasData;
            if (!(dataSourceBaseList.get(i) instanceof RawDataSource) || (hasData = ((RawDataSource)dataSourceBaseList.get(i)).getRawData()) == null) continue;
            hasRawDataIndex = i;
            rawData = hasData;
            break;
        }
        if (rawData == null) {
            return;
        }
        ((RawDataSource)first).setRawData(rawData);
        for (Object key : rawData.keySet()) {
            Object firstParaValue = rawData.get(key);
            if (!(firstParaValue instanceof Collection)) continue;
            Collection firstParaValueCollection = (Collection)firstParaValue;
            for (int i = 0; i < dataSourceBaseList.size(); ++i) {
                DataSourceBase dataSourceBase;
                if (i == 0 || i == hasRawDataIndex || !((dataSourceBase = dataSourceBaseList.get(i)) instanceof RawDataSource) || !MapUtils.isNotEmpty(((RawDataSource)dataSourceBase).getRawData())) continue;
                HashMap<String, Object> paras = ((RawDataSource)dataSourceBase).getRawData();
                if (paras.containsKey(key)) {
                    firstParaValueCollection.addAll((Collection)paras.get(key));
                }
                if (dataSourceBase.getLimit() == null) continue;
                if (first.getLimit() == null) {
                    first.setLimit(0);
                }
                first.setLimit(first.getLimit() + dataSourceBase.getLimit());
            }
        }
    }

    private boolean businessUnitIsSame(List<DataSourceBase> dataSourceBaseList) {
        if (CollectionUtils.isEmpty(dataSourceBaseList) || dataSourceBaseList.size() == 1) {
            return true;
        }
        Map businessUnit = null;
        for (DataSourceBase dataSource : dataSourceBaseList) {
            if (null == dataSource || null == dataSource.getAction() || null == dataSource.getAction().getBusinessUnit()) continue;
            if (null == businessUnit) {
                businessUnit = dataSource.getAction().getBusinessUnit();
                continue;
            }
            Map tmpBusinessUnit = dataSource.getAction().getBusinessUnit();
            if (businessUnit.size() != tmpBusinessUnit.size()) {
                return false;
            }
            if (UnionDataSource.compare(businessUnit, tmpBusinessUnit)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        if (queryResult == null || CollectionUtils.isEmpty(this.unionItems)) {
            return null;
        }
        return this.unionItems.get(0).queryMetaData(executeContext, parameter, queryResult);
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        UnionDataSource unionDataSource = new UnionDataSource();
        unionDataSource.setName(this.getName());
        unionDataSource.setAction(this.getAction());
        unionDataSource.setType(this.getType());
        unionDataSource.setDataKeys(this.getDataKeys());
        unionDataSource.setActionId(this.getActionId());
        if (CollectionUtils.isNotEmpty(this.unionItems)) {
            ArrayList<DataSourceBase> dataSourceBases = new ArrayList<DataSourceBase>();
            for (DataSourceBase dataSourceBase : this.unionItems) {
                dataSourceBases.add(dataSourceBase.copyWithoutProcessorCore());
            }
            unionDataSource.setUnionItems(dataSourceBases);
        }
        return unionDataSource;
    }

    public static boolean compare(Map<String, Object> map1, Map<String, Object> map2) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        JsonNode node1 = mapper.valueToTree(map1);
        JsonNode node2 = mapper.valueToTree(map2);
        return node1.equals((Object)node2);
    }

    @Generated
    public Boolean getMergeQuery() {
        return this.mergeQuery;
    }

    @Generated
    public List<DataSourceBase> getUnionItems() {
        return this.unionItems;
    }

    @Generated
    public void setMergeQuery(Boolean mergeQuery) {
        this.mergeQuery = mergeQuery;
    }

    @Generated
    public void setUnionItems(List<DataSourceBase> unionItems) {
        this.unionItems = unionItems;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnionDataSource)) {
            return false;
        }
        UnionDataSource other = (UnionDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$mergeQuery = this.getMergeQuery();
        Boolean other$mergeQuery = other.getMergeQuery();
        if (this$mergeQuery == null ? other$mergeQuery != null : !((Object)this$mergeQuery).equals(other$mergeQuery)) {
            return false;
        }
        List<DataSourceBase> this$unionItems = this.getUnionItems();
        List<DataSourceBase> other$unionItems = other.getUnionItems();
        return !(this$unionItems == null ? other$unionItems != null : !((Object)this$unionItems).equals(other$unionItems));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UnionDataSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $mergeQuery = this.getMergeQuery();
        result = result * 59 + ($mergeQuery == null ? 43 : ((Object)$mergeQuery).hashCode());
        List<DataSourceBase> $unionItems = this.getUnionItems();
        result = result * 59 + ($unionItems == null ? 43 : ((Object)$unionItems).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "UnionDataSource(mergeQuery=" + this.getMergeQuery() + ", unionItems=" + this.getUnionItems() + ")";
    }
}

