/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.atdm.datasource.domain.BacklogData;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.TaskWithBacklogData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ApprovalUtil {
    public static void addTaskData(ExecuteContext executeContext, TaskWithBacklogData taskWithBacklogData, BacklogData firstBacklogData, Map<String, Object> data) {
        Map workitem;
        JSONObject dataItem = new JSONObject();
        dataItem.put((Object)"approve", (Object)0);
        if (!CollectionUtils.isEmpty((Collection)firstBacklogData.getWorkitemList()) && (workitem = (Map)firstBacklogData.getWorkitemList().get(0)).containsKey("state")) {
            dataItem.put((Object)"approve", workitem.get("state"));
            if (workitem.containsKey("subState")) {
                dataItem.put((Object)"subState", workitem.get("subState"));
            }
        }
        ArrayList processInstances = new ArrayList();
        HashMap<String, Object> processInstance = new HashMap<String, Object>();
        processInstance.put("processSerialNumber", taskWithBacklogData.getProcessSerialNumber());
        ArrayList<String> tmActivityIds = new ArrayList<String>();
        tmActivityIds.add(executeContext.getTmActivityId());
        processInstance.put("tmActivityIds", tmActivityIds);
        processInstance.put("workitemId", firstBacklogData.getBacklogId());
        processInstances.add(processInstance);
        dataItem.put((Object)"processInstances", processInstances);
        data.put("activity__approval__state", dataItem);
    }

    public static void addTaskData(TaskWithBacklogData taskWithBacklogData, BacklogData firstBacklogData, Map<String, Object> data) {
        Map workitem;
        JSONObject dataItem = new JSONObject();
        dataItem.put((Object)"approve", (Object)0);
        if (!CollectionUtils.isEmpty((Collection)firstBacklogData.getWorkitemList()) && (workitem = (Map)firstBacklogData.getWorkitemList().get(0)).containsKey("state")) {
            dataItem.put((Object)"approve", workitem.get("state"));
            if (workitem.containsKey("subState")) {
                dataItem.put((Object)"subState", workitem.get("subState"));
            }
        }
        dataItem.put((Object)"processInstances", Arrays.asList(taskWithBacklogData.getRelationApproval()));
        data.put("activity__approval__state", dataItem);
    }

    public static Map<String, Object> addReturnComments(BacklogData firstBacklogData, Map<String, Object> data) {
        HashMap<String, Object> returnComment = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty((Collection)firstBacklogData.getWorkitemList())) {
            return returnComment;
        }
        Map workitem = (Map)firstBacklogData.getWorkitemList().get(0);
        if (!workitem.containsKey("returnWorkitem")) {
            return returnComment;
        }
        Map returnWorkitem = (Map)workitem.get("returnWorkitem");
        if (!(returnWorkitem.containsKey("dataItems") && returnWorkitem.containsKey("uniKeys") && returnWorkitem.containsKey("comment"))) {
            return returnComment;
        }
        List dataItems = (List)returnWorkitem.get("dataItems");
        List uniKeys = (List)returnWorkitem.get("uniKeys");
        for (Map dataItem : dataItems) {
            String dataKeyStr;
            String dataItemKeyStr = ApprovalUtil.generateIndexKey(uniKeys, dataItem);
            if (StringUtils.isEmpty((Object)dataItemKeyStr) || StringUtils.isEmpty((Object)(dataKeyStr = ApprovalUtil.generateIndexKey(uniKeys, data))) || !dataItemKeyStr.equals(dataKeyStr)) continue;
            returnComment.put("returnComment", returnWorkitem.get("comment"));
        }
        return returnComment;
    }

    private static <T> String generateIndexKey(List<String> mapKeys, Map<String, T> map) {
        int i = 0;
        for (String tempKey : mapKeys) {
            if (!map.containsKey(tempKey)) continue;
            ++i;
        }
        StringBuilder indexKey = new StringBuilder();
        if (i == mapKeys.size()) {
            for (String tempKey : mapKeys) {
                indexKey.append(MapUtils.getString(map, (Object)tempKey)).append(";");
            }
        }
        return indexKey.toString();
    }
}

