/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.aam.CommonAttachmentService;
import com.digiwin.athena.atdm.aam.dto.AttachmentEntity;
import com.digiwin.athena.atdm.activity.domain.AttachmentConfig;
import com.digiwin.athena.atdm.activity.domain.AttachmentConfigInfo;
import com.digiwin.athena.atdm.constant.ErrorCodeEnum;
import com.digiwin.athena.atdm.datasource.BuildPageDataProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.process.AttachmentUtil;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.QueryResultSet;
import com.digiwin.athena.atdm.datasource.domain.TagDefinition;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="attachmentDataService")
public class AttachmentDataSourceService
implements BuildPageDataProcessService,
DataSourceProcessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentDataSourceService.class);
    public static final String ATTACHMENT_DS_SERVICE_INSTANCE_NAME = "attachmentDataService";
    @Autowired
    private CommonAttachmentService commonAttachmentService;
    @Autowired
    private MessageUtils messageUtils;
    private static final String SCHEMA = "attachment";

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (!AttachmentUtil.isPageCodeEnableAttachment(executeContext.getPageCode())) {
            return;
        }
        AttachmentConfigInfo attachmentConfigInfo = AttachmentUtil.toAttachment(dataSourceProcessor.getParas());
        this.handelMetadata(executeContext, attachmentConfigInfo, queryResult);
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (!AttachmentUtil.isPageCodeEnableAttachment(executeContext.getPageCode())) {
            return;
        }
        if (!AttachmentUtil.sourceTypeEnableAttachment(dataSourceBase.getType())) {
            return;
        }
        AttachmentConfigInfo attachmentConfigInfo = AttachmentUtil.toAttachment(dataSourceProcessor.getParas());
        this.handelData(executeContext, attachmentConfigInfo, queryResult);
    }

    public void handelPageData(ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResultSet queryResultSet) {
        if (!AttachmentUtil.isPageCodeEnableAttachment(executeContext.getPageCode())) {
            return;
        }
        AttachmentConfigInfo attachmentConfigInfo = AttachmentUtil.toAttachment(dataSourceProcessor.getParas());
        this.handelMetadata(executeContext, attachmentConfigInfo, queryResultSet.getMainQueryResult());
        this.handelData(executeContext, attachmentConfigInfo, queryResultSet.getMainQueryResult());
    }

    private void handelMetadata(ExecuteContext executeContext, AttachmentConfigInfo attachmentConfigInfo, QueryResult queryResult) {
        this.addAttachmentFileMetadataField(queryResult.getApiMetadataCollection(), attachmentConfigInfo);
    }

    private void addAttachmentFileMetadataField(ApiMetadataCollection apiMetadataCollection, AttachmentConfigInfo attachmentConfigInfo) {
        if (apiMetadataCollection == null) {
            return;
        }
        List attachmentConfigs = attachmentConfigInfo.getConfigs();
        for (int idx = 0; idx < attachmentConfigs.size(); ++idx) {
            AttachmentConfig attachmentConfig = (AttachmentConfig)attachmentConfigs.get(idx);
            MetadataField attachmentField = new MetadataField();
            attachmentField.setUiBot("Y");
            if (StringUtils.isNotBlank((CharSequence)attachmentConfig.getTargetSchema())) {
                attachmentField.setName(attachmentConfig.getTargetSchema());
            } else {
                attachmentField.setName(SCHEMA + idx);
            }
            attachmentField.setDataType("object");
            String description = Optional.ofNullable(attachmentConfig.getDescription()).map(AttachmentConfig.Description::getTitle).orElse(this.messageUtils.getMessage("uibot.activity.metadataField.attachment"));
            attachmentField.setDescription(description);
            attachmentField.setTagDefinitions(AttachmentDataSourceService.buildAttachmentFileTagDefs(description, description));
            ArrayList<MetadataField> subFields = new ArrayList<MetadataField>();
            MetadataField rowData = new MetadataField();
            rowData.setName("row_data");
            rowData.setDataType("string");
            rowData.setDataKey("false");
            rowData.setBusinessKey(Boolean.valueOf(false));
            rowData.setRequired(false);
            rowData.setArray(Boolean.valueOf(false));
            subFields.add(rowData);
            MetadataField data = new MetadataField();
            data.setName("data");
            data.setDataType("object");
            data.setDataKey("false");
            data.setBusinessKey(Boolean.valueOf(false));
            data.setRequired(false);
            data.setArray(Boolean.valueOf(true));
            data.setSubFields(new ArrayList());
            subFields.add(data);
            attachmentField.setSubFields(subFields);
            List metadataFields = ((MetadataField)apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0)).getSubFields();
            List attachmentList = metadataFields.stream().filter(a -> attachmentField.getName().equals(a.getName())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(attachmentList)) {
                metadataFields.removeAll(attachmentList);
            }
            metadataFields.add(attachmentField);
        }
    }

    public static List<TagDefinition> buildAttachmentFileTagDefs(String tagName, String tagDescription) {
        ArrayList tagDefinitions = Lists.newArrayList();
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setCode("BUSINESS_ATTACHMENT_FILE");
        tagDefinition.setName(tagName);
        tagDefinition.setDescription(tagDescription);
        tagDefinition.setCategory("BUSINESS");
        tagDefinition.setInterpreterServiceName("attachmentFileInterpreter");
        tagDefinition.setCustomize(Boolean.valueOf(false));
        tagDefinitions.add(tagDefinition);
        return tagDefinitions;
    }

    public void handelData(ExecuteContext executeContext, AttachmentConfigInfo attachmentConfigInfo, QueryResult queryResult) {
        List rowDataList = queryResult.getData();
        if (CollectionUtils.isEmpty((Collection)rowDataList)) {
            return;
        }
        List<String> rowDataKeyList = rowDataList.stream().map(rowData -> Optional.ofNullable(rowData.get("__DATA_KEY")).map(Object::toString).orElse("")).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(rowDataKeyList)) {
            throw BusinessException.create((String)ErrorCodeEnum.NUM_500_0031.getErrCode(), (String)this.messageUtils.getMessage("exception.api.config.lack.dataKey"));
        }
        String tenantId = executeContext.getTenantId();
        String projectId = executeContext.getTmProjectId();
        List attachmentConfigs = attachmentConfigInfo.getConfigs();
        for (int idx = 0; idx < attachmentConfigs.size(); ++idx) {
            AttachmentConfig attachmentConfig = (AttachmentConfig)attachmentConfigs.get(idx);
            List<String> categories = AttachmentUtil.getQueryCategories(attachmentConfig);
            if (CollectionUtils.isEmpty(categories)) continue;
            if (null == attachmentConfig.getDisableAam() || BooleanUtils.isFalse((Boolean)attachmentConfig.getDisableAam())) {
                List<AttachmentEntity> attachEntities = this.queryRowDataAttachmentList(tenantId, attachmentConfig.getTaskId(), projectId, categories, rowDataKeyList);
                String fieldName = StringUtils.isBlank((CharSequence)attachmentConfig.getTargetSchema()) ? SCHEMA + idx : attachmentConfig.getTargetSchema();
                this.putAttachmentToRowData(fieldName, rowDataList, attachEntities);
                continue;
            }
            String fieldName = StringUtils.isBlank((CharSequence)attachmentConfig.getTargetSchema()) ? SCHEMA + idx : attachmentConfig.getTargetSchema();
            for (Map rowData2 : rowDataList) {
                if (null == rowData2.get(fieldName) || rowData2.get(fieldName) instanceof Map && MapUtils.isEmpty((Map)((Map)rowData2.get(fieldName)))) {
                    String rowDataKey = Optional.ofNullable(rowData2.get("__DATA_KEY")).map(Object::toString).orElse("");
                    HashMap attachmentRowData = Maps.newHashMap();
                    attachmentRowData.put("row_data", rowDataKey);
                    attachmentRowData.put("data", Collections.emptyList());
                    rowData2.put(fieldName, attachmentRowData);
                    continue;
                }
                if (null == rowData2.get(fieldName) || rowData2.get(fieldName) instanceof Map) continue;
                log.warn("\u9644\u4ef6\u65e5\u5fd7{}\u4f5c\u4e1a\u7684\u4e1a\u52a1\u6570\u636e{}\u503c\u4e0d\u662fMap\u7c7b\u578b\uff0c\u4e0d\u7b26\u5408\u9644\u4ef6\u6570\u636e\u683c\u5f0f\u89c4\u8303", (Object)executeContext.getTmActivityId(), (Object)fieldName);
            }
        }
    }

    private List<AttachmentEntity> queryRowDataAttachmentList(String tenantId, String taskId, String projectId, List<String> categories, List<String> rowDataKeyList) {
        return this.commonAttachmentService.queryRowDataAttachmentList(tenantId, taskId, projectId, categories, rowDataKeyList);
    }

    private void putAttachmentToRowData(String fieldName, List<Map<String, Object>> rowDataList, List<AttachmentEntity> attachEntities) {
        if (CollectionUtils.isEmpty(attachEntities)) {
            for (Map<String, Object> rowData : rowDataList) {
                String string = Optional.ofNullable(rowData.get("__DATA_KEY")).map(Object::toString).orElse("");
                rowData.put(fieldName, this.buildAttachmentRowData(string, null));
            }
        }
        HashMap rowDataKeyAttachEntitiesMap = Maps.newHashMapWithExpectedSize((int)attachEntities.size());
        for (AttachmentEntity attachmentEntity : attachEntities) {
            List rowAttachEntities = rowDataKeyAttachEntitiesMap.computeIfAbsent(attachmentEntity.getRowDataKey(), rowDataKey -> Lists.newArrayList());
            rowAttachEntities.add(attachmentEntity);
        }
        for (Map map : rowDataList) {
            String rowDataKey3 = Optional.ofNullable(map.get("__DATA_KEY")).map(Object::toString).orElse("");
            List rowAttachEntities = (List)rowDataKeyAttachEntitiesMap.get(rowDataKey3);
            if (CollectionUtils.isNotEmpty((Collection)rowAttachEntities)) {
                ArrayList attachmentRowData = Lists.newArrayList();
                for (AttachmentEntity rowAttachEntity : rowAttachEntities) {
                    AttachmentEntity newAttachmentEntity = AttachmentEntity.builder().id(rowAttachEntity.getId()).name(rowAttachEntity.getName()).rowDataKey(rowAttachEntity.getRowDataKey()).category(rowAttachEntity.getCategory()).categoryId(rowAttachEntity.getCategoryId()).uploadUserId(rowAttachEntity.getUploadUserId()).uploadUserName(rowAttachEntity.getUploadUserName()).defence(rowAttachEntity.getDefence()).size(rowAttachEntity.getSize()).build();
                    newAttachmentEntity.setCreateDate(rowAttachEntity.getCreateDate());
                    attachmentRowData.add(newAttachmentEntity);
                }
                map.put(fieldName, this.buildAttachmentRowData(rowDataKey3, attachmentRowData));
                continue;
            }
            map.put(fieldName, this.buildAttachmentRowData(rowDataKey3, null));
        }
    }

    private Map<String, Object> buildAttachmentRowData(String rowDataKey, List<AttachmentEntity> data) {
        HashMap attachmentRowData = Maps.newHashMap();
        attachmentRowData.put("rowDataKey", rowDataKey);
        if (CollectionUtils.isNotEmpty(data)) {
            attachmentRowData.put("data", data);
        } else {
            attachmentRowData.put("data", Collections.emptyList());
        }
        return attachmentRowData;
    }
}

