/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.BacklogData;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.ProjectData;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.TaskWithBacklogData;
import com.digiwin.athena.atdm.fi.CommonForecastingIntelligenceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="recommendProcessService")
public class RecommendProcessService
implements DataSourceProcessService {
    private static final String PLAN_TYPE_REASON_FILED_NAME = "UIBOT_PLAN_TYPE_REASON";
    private static final String PLAN_TYPE_RECOMMEND_FIELD_NAME = "UIBOT_PLAN_TYPE_RECOMMEND_REASON";
    @Autowired
    private CommonForecastingIntelligenceService commonForecastingIntelligenceService;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = queryResult.getApiMetadataCollection();
        if (apiMetadataCollection == null) {
            return;
        }
        if (apiMetadataCollection != null && apiMetadataCollection.getMasterApiMetadata() != null && CollectionUtils.isNotEmpty((Collection)apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {
            List metadataFields = ((MetadataField)apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0)).getSubFields();
            MetadataField planTypeReasonField = new MetadataField();
            planTypeReasonField.setUiBot("Y");
            planTypeReasonField.setName(PLAN_TYPE_REASON_FILED_NAME);
            planTypeReasonField.setDataType("string");
            HashMap<String, Integer> planPrecision = new HashMap<String, Integer>();
            planPrecision.put("length", 120);
            planTypeReasonField.setPrecision(planPrecision);
            planTypeReasonField.setDescription(MessageUtils.getMessageByCurrentLanguage((Object)"{\"zh_TW\":\"\u65b9\u6848\u9078\u64c7\u7406\u7531\",\"en_US\":\"Reasons for plan selection\",\"zh_CN\":\"\u65b9\u6848\u9009\u62e9\u7406\u7531\"}"));
            metadataFields.add(planTypeReasonField);
            MetadataField recommendReasonField = new MetadataField();
            recommendReasonField.setUiBot("Y");
            recommendReasonField.setName(PLAN_TYPE_RECOMMEND_FIELD_NAME);
            recommendReasonField.setDataType("string");
            HashMap<String, Integer> reasonPrecision = new HashMap<String, Integer>();
            reasonPrecision.put("length", 120);
            recommendReasonField.setPrecision(reasonPrecision);
            recommendReasonField.setDescription(MessageUtils.getMessageByCurrentLanguage((Object)"{\"zh_TW\":\"\u63a8\u85a6\u7406\u7531\",\"en_US\":\"Recommended reason\",\"zh_CN\":\"\u63a8\u8350\u7406\u7531\"}"));
            metadataFields.add(recommendReasonField);
        }
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (queryResult == null || CollectionUtils.isEmpty((Collection)queryResult.getData())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)dataSourceProcessor.getDataSourceNames()) || dataSourceProcessor.getDataSourceNames().contains(queryResult.getDataSourceName())) {
            ProjectData projectData;
            Map data = new HashMap<String, List>();
            for (Map datum : queryResult.getData()) {
                datum.put(PLAN_TYPE_REASON_FILED_NAME, "");
                datum.put(PLAN_TYPE_RECOMMEND_FIELD_NAME, "");
            }
            data.put(queryResult.getDataSourceName(), queryResult.getData());
            ArrayList<Map> fiAmendData = new ArrayList<Map>();
            if (dataSourceProcessor.getParas() != null) {
                Map plan = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)dataSourceProcessor.getParas()), Map.class);
                plan.put("dataSourceName", queryResult.getDataSourceName());
                fiAmendData.add(plan);
            }
            HashMap<String, String> user = new HashMap<String, String>();
            user.put("userId", executeContext.getAuthoredUser().getUserId());
            user.put("userName", executeContext.getAuthoredUser().getUserName());
            user.put("tenantId", executeContext.getAuthoredUser().getTenantId());
            user.put("tenantName", executeContext.getAuthoredUser().getTenantName());
            HashMap<String, Object> task = new HashMap<String, Object>();
            task.put("identity", executeContext.getIdentity());
            TaskWithBacklogData taskWithBacklogData = dataSourceProcessor.getTaskWithBacklogData();
            if (taskWithBacklogData != null) {
                task.put("backlogId", ((BacklogData)taskWithBacklogData.getBacklog().get(0)).getBacklogId());
                task.put("startTime", ((BacklogData)taskWithBacklogData.getBacklog().get(0)).getStartTime());
                task.put("planEndTime", ((BacklogData)taskWithBacklogData.getBacklog().get(0)).getPlanEndTime());
                task.put("backlogName", ((BacklogData)taskWithBacklogData.getBacklog().get(0)).getBacklogName());
                task.put("performerId", ((BacklogData)taskWithBacklogData.getBacklog().get(0)).getPerformerId());
                task.put("performerName", ((BacklogData)taskWithBacklogData.getBacklog().get(0)).getPerformerName());
                task.put("tmActivityId", taskWithBacklogData.getTmActivityId());
                task.put("activityType", taskWithBacklogData.getBpmActivityType());
                task.put("pattern", taskWithBacklogData.getTmPattern());
                task.put("category", taskWithBacklogData.getTmCategory());
            }
            if ((projectData = dataSourceProcessor.getProjectData()) != null) {
                task.put("projectId", projectData.getProjectId());
                task.put("projectName", projectData.getProjectName());
                task.put("tmProjectId", projectData.getTmProjectId());
            } else {
                task.put("projectId", "");
                task.put("projectName", "");
                task.put("tmProjectId", "");
            }
            Map result = this.commonForecastingIntelligenceService.taskaction(data, user, task, fiAmendData);
            if (MapUtils.isNotEmpty((Map)result) && result.containsKey("data")) {
                data = (Map)result.get("data");
                List list = (List)data.get(queryResult.getDataSourceName());
                queryResult.getData().clear();
                queryResult.getData().addAll(list);
            }
        }
    }
}

