package com.digiwin.athena.atdm.datasource.dto;

import com.digiwin.athena.atdm.activity.domain.TmQueryAction;
import lombok.Data;

import java.util.List;
import java.util.Map;


@Data
public class QueryDataByActionDTO {
    /**
     * tmAction 定义
     */
    private TmQueryAction tmAction;
    /**
     * 业务单元
     */
    private Map<String, Object> businessUnit;
    /**
     * 业务参数数据
     */
    private Map<String,Object> bpmData;

    /**
     * 直接传参数
     */
    private Map<String,Object> paras;
    /**
     * 分页查询参数
     */
    private PageInfo pageInfo;
    /**
     * 排序
     *  "sort_info" : [{
     *           "sort_field" : "requisitions_no",
     *           "sort_type" : "asc",
     *           "sort_seq" : "1"
     *       },{
     *           "sort_field" : "requisitions_seq",
     *           "sort_type" : "desc",
     *           "sort_seq" : "2"
     *       }]
     */
    private List<Map> sortInfo;
    /**
     * 通用过滤
     * "search_info": [
     *         {
     *           "search_field": "name",
     *           "search_operator": "equal",
     *           "search_value": "印表機"
     *         },
     *         {
     *           "search_field": "status",
     *           "search_operator": "equal",
     *           "search_value": "生效"
     *         }
     *       ]
     */
    private List<Map> searchInfo;

}
