/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.StringUtils;

public class RawDataSource
extends DataSourceBase {
    private HashMap<String, Object> rawData;

    public RawDataSource() {
        this.setType("RAWDATA");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (this.rawData == null) {
            return QueryResult.empty((String)this.getName());
        }
        AtomicReference queryResult = new AtomicReference();
        this.rawData.forEach((k, v) -> {
            if (v instanceof Collection) {
                queryResult.set(QueryResult.withData((String)this.getName(), (List)((List)v)));
            } else if (v instanceof Map) {
                queryResult.set(QueryResult.withSingleData((String)this.getName(), (Map)((Map)v)));
            } else {
                HashMap<String, Object> vv_t = new HashMap<String, Object>();
                vv_t.put((String)k, v);
                queryResult.set(QueryResult.withSingleData((String)this.getName(), vv_t));
            }
        });
        return (QueryResult)queryResult.get();
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        String actionId = this.getActionId();
        ApiMetadata apiMetadata = null;
        if (StringUtils.hasText((String)actionId)) {
            apiMetadata = ((CommonMetadataService)SpringUtil.getBean(CommonMetadataService.class)).getMetadata(executeContext.getLocale(), this.getActionId());
        } else {
            List<MetadataField> metadataFields = this.getMetadataFields();
            if (CollectionUtils.isNotEmpty(metadataFields)) {
                MetadataField metadataField = metadataFields.get(0);
                apiMetadata = new ApiMetadata();
                apiMetadata.setActionId(metadataField.getName());
            }
        }
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        RawDataSource rawDataSource = new RawDataSource();
        rawDataSource.setName(this.getName());
        rawDataSource.setAction(this.getAction());
        rawDataSource.setType(this.getType());
        rawDataSource.setDataKeys(this.getDataKeys());
        rawDataSource.setActionId(this.getActionId());
        rawDataSource.setRawData(this.rawData);
        return rawDataSource;
    }

    @Generated
    public HashMap<String, Object> getRawData() {
        return this.rawData;
    }

    @Generated
    public void setRawData(HashMap<String, Object> rawData) {
        this.rawData = rawData;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawDataSource)) {
            return false;
        }
        RawDataSource other = (RawDataSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HashMap<String, Object> this$rawData = this.getRawData();
        HashMap<String, Object> other$rawData = other.getRawData();
        return !(this$rawData == null ? other$rawData != null : !((Object)this$rawData).equals(other$rawData));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RawDataSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HashMap<String, Object> $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : ((Object)$rawData).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "RawDataSource(rawData=" + this.getRawData() + ")";
    }
}

