/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity;

import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.DataUnfiormityProcessor;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="removeAbnormalDataService")
public class RemoveAbnormalDataService
implements DataSourceProcessService {
    @Autowired
    private DataUnfiormityProcessor dataUnfiormityProcessor;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        List dataList = queryResult.getData();
        if (CollectionUtils.isEmpty((Collection)dataList) || null == dataSourceProcessor.getParas()) {
            return;
        }
        Set<Map<String, Object>> abnormalDataSet = this.dataUnfiormityProcessor.comparisonData(dataList, dataSourceProcessor);
        ArrayList<Map> resultList = new ArrayList<Map>();
        for (Map dataMap : dataList) {
            if (abnormalDataSet.contains(dataMap)) continue;
            resultList.add(dataMap);
        }
        int totalKeySize = queryResult.keySize();
        queryResult.setData(resultList);
        queryResult.initializeDataKey();
        queryResult.setAbnormalDataSize(Integer.valueOf(abnormalDataSet.size()));
        queryResult.setAbnormalDataKeyIndexSize(Integer.valueOf(totalKeySize - queryResult.keySize()));
    }
}

