package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import lombok.Data;
import org.apache.commons.collections4.MapUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class AFCOperationDataSource extends DataSourceBase {


    public AFCOperationDataSource( ){
        super();
        this.setType(UiBotConstants.DATA_AFC);
    }



    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (this.getAction() == null){
            return QueryResult.empty(this.getName());
        }
        /**
         * 获取
         */

        Map<String, Object> value = SpringUtil.getBean(CommonUiBotService.class).getAFCData();
        Map<String,List<Object>> espData = new HashMap<>();
        List<Object> list = (List<Object>) value.get("modelList");
        this.addKeys(list);
        espData.put("response", list);
        QueryResult queryResult = QueryResult.withData( this.getName(),espData);
        queryResult.withMetaData(JsonUtils.jsonToObject(JsonUtils.objectToString(value.get("apiMetadataCollection")),ApiMetadataCollection.class));
        return  queryResult;
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        return null;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        return null;
    }

    private void addKeys(List<Object> list){
        list.stream().forEach(m ->{
            StringBuilder dataKeys = new StringBuilder();
            Map<String,Object> keyMap = (Map<String, Object>) m;
            this.getDataKeys().forEach(key -> {
                dataKeys.append(MapUtils.getObject(keyMap,key)).append(";");
            });
            keyMap.put("__DATA_KEY",dataKeys.toString());
        });

    }
}
