package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.atdm.ActionConstants;
import com.digiwin.athena.atdm.UiBotConstants;
import com.digiwin.athena.atdm.datasource.domain.BacklogData;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.TaskWithBacklogData;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * 异常排除数据处理工具
 */
public class SolveUtil {

    public static  void addTraceData(ExecuteContext executeContext, String detailField, TaskWithBacklogData taskWithBacklogData, BacklogData firstBacklogData, Map<String, Object> data) {
        // 附加数据处理进度
        JSONObject stateData = taskWithBacklogData.getStateData();
        SolveUtil.addTraceData(detailField, executeContext, data, firstBacklogData, taskWithBacklogData, stateData);
        // 如果有明细数据也要处理
        if (detailField != null && data.get(detailField) != null) {
            List<Map<String, Object>> detail = (List<Map<String, Object>>) data.get(detailField);
            for (Map<String, Object> detailItem : detail) {
                SolveUtil.addTraceData(detailField, executeContext, detailItem, firstBacklogData, taskWithBacklogData,
                        stateData);
            }
        }

    }
    static void addTraceData(String detailField, ExecuteContext executeContext, Map<String, Object> data,
                              BacklogData firstBacklogData, TaskWithBacklogData taskWithBacklogData, JSONObject stateData) {
        if (stateData != null && !stateData.isEmpty()) {
            String dataKeys = stateData.getString("dataKeys");
            String originalQueryVariableName = stateData.getString("originalQueryVariableName");
            JSONArray traceDataList = stateData.getJSONArray(originalQueryVariableName);
            String[] dataKeyList = dataKeys.split(";");
            String queryItemKeyValue = "";
            for (String keyItem : dataKeyList) {
                if(data.get(keyItem) != null) {
                    queryItemKeyValue += data.get(keyItem).toString();
                }
            }
            boolean isFind = false;
            for (Object item : traceDataList) {
                JSONObject dataItem = (JSONObject) item;
                String existedItemKeyValue = "";
                for (String keyItem : dataKeyList) {
                    if(dataItem.get(keyItem) != null) {
                        existedItemKeyValue += dataItem.getString(keyItem);
                    }
                }
                if (queryItemKeyValue.equals(existedItemKeyValue) && dataItem.containsKey("processInstances")
                        && !CollectionUtils.isEmpty(dataItem.getJSONArray("processInstances"))) {
                    dataItem.put("dataKeys", dataKeys);
                    dataItem.put("backlogId", firstBacklogData.getBacklogId());
                    dataItem.put("originalQueryVariableName", originalQueryVariableName);
                    dataItem.put("solvePlanFieldName", stateData.get("solvePlanFieldName"));
                    dataItem.put("taskProblematicData", stateData.get("taskProblematicData"));
                    dataItem.put("approve", "");
                    data.put("activity__approval__state", dataItem);
                    isFind = true;
                    break;
                }
            }
            if (!isFind) {
                JSONObject dataItem = new JSONObject();
                dataItem.put("approve", "");
                data.put("activity__approval__state", dataItem);
            }
            // 处理是否可撤回
            if (!CollectionUtils.isEmpty(taskWithBacklogData.getAbortDataKeys())) {
                for (Object abortKey : taskWithBacklogData.getAbortDataKeys()) {
                    JSONObject akJSON = (JSONObject) abortKey;
                    String existedItemKeyValue = "";
                    for (String keyItem : dataKeyList) {
                        if(akJSON.get("dataKey") != null && akJSON.getJSONObject("dataKey").get(keyItem) != null) {
                            existedItemKeyValue += akJSON.getJSONObject("dataKey").getString(keyItem);
                        }
                    }
                    if (queryItemKeyValue.equals(existedItemKeyValue)) {
                        JSONObject dataItem = (JSONObject) data.get("activity__approval__state");
                        JSONObject abortAction = createAbortTaskAction(detailField, executeContext, akJSON,
                                firstBacklogData.getBacklogId(), taskWithBacklogData);
                        dataItem.put("abortAction", abortAction);
                        break;
                    }
                }
            }

        } else {
            JSONObject dataItem = new JSONObject();
            dataItem.put("approve", "");
            data.put("activity__approval__state", dataItem);
        }
    }


    static JSONObject createAbortTaskAction(String detailField, ExecuteContext executeContext, JSONObject abortData,
                                             Long backlogId, TaskWithBacklogData taskWithBacklogData) {
        // 结构按照 SubmitAction
        JSONObject action = new JSONObject();
        action.put("id", ActionConstants.ACTION_NAME_ABORT_TASK_NAME);
        action.put("title", "关卡撤回");
        action.put("actionId", ActionConstants.ACTION_NAME_ABORT_TASK_NAME);
        action.put("invokeType", "sync");
        action.put("category", UiBotConstants.ACTION_CATEGORY_UIBOT);
        JSONObject serviceId = new JSONObject();
        serviceId.put("name", ActionConstants.ACTION_NAME_ABORT_TASK_NAME);
        action.put("serviceId", serviceId);
        if(taskWithBacklogData.getBusinessUnit()!=null){
            action.put("businessUnit", taskWithBacklogData.getBusinessUnit());
        }else {
            action.put("businessUnit", executeContext.getBusinessUnit());
        }

        JSONObject extendParas = new JSONObject();
        extendParas.putAll(abortData);
        if (!StringUtils.isEmpty(detailField)) {
            extendParas.put("detailField", detailField);
        }
        action.put("extendParas", extendParas);

        JSONObject ec = new JSONObject();
        ec.put("tmProjectId", executeContext.getTmProjectId());
        ec.put("tmActivityId", executeContext.getTmActivityId());
        ec.put("pageCode", executeContext.getPageCode());
        ec.put("pattern", executeContext.getPattern());
        ec.put("category", executeContext.getCategory());
        ec.put("backlogId", backlogId);
        action.put("executeContext", ec);
        return action;

    }

}
