/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.process.CustomizeTagUtils;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.TagDefinition;
import com.digiwin.athena.atdm.datasource.domain.ThemeMapTag;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.retrieveData.CommonRetrieveDataService;
import com.digiwin.athena.atdm.terminateData.CommonTerminateDataService;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ShelvedDataSource
extends DataSourceBase {
    public ShelvedDataSource() {
        this.setType("SHELVED_DATA");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        ArrayList<String> workItemIds = new ArrayList();
        String loginUserId = null;
        if (null != this.getAction()) {
            workItemIds = Optional.ofNullable(this.getAction().getParas()).map(paras -> (List)paras.get("allWorkItemId")).orElse(Collections.emptyList());
            loginUserId = Optional.ofNullable(this.getAction().getParas()).map(paras -> (String)paras.get("uibot_login_userId")).orElse("");
        } else {
            workItemIds = Optional.ofNullable(this.getExtendedData()).map(extendedData -> (List)extendedData.get("allWorkItemId")).orElse(Collections.emptyList());
            loginUserId = Optional.ofNullable(this.getExtendedData()).map(extendedData -> (String)extendedData.get("uibot_login_userId")).orElse("");
        }
        if (CollectionUtils.isEmpty(workItemIds)) {
            return QueryResult.empty((String)this.getName());
        }
        AuthoredUser authoredUser = null != AppAuthContextHolder.getContext().getProxyAuthoredUser() ? AppAuthContextHolder.getContext().getProxyAuthoredUser() : AppAuthContextHolder.getContext().getAuthoredUser();
        String userId = StringUtils.isNotBlank((CharSequence)loginUserId) ? loginUserId : authoredUser.getUserId();
        List dataList = this.queryShelvedDataList(authoredUser, userId, executeContext.getTmActivityId(), workItemIds);
        return CollectionUtils.isNotEmpty((Collection)dataList) ? QueryResult.withData((String)this.getName(), (List)dataList) : QueryResult.empty((String)this.getName());
    }

    private List queryShelvedDataList(AuthoredUser authoredUser, String userId, String tmActivityId, List<String> workItemIdList) {
        List terminateDataList = ((CommonTerminateDataService)SpringUtil.getBean(CommonTerminateDataService.class)).queryTerminateDataList(authoredUser.getToken(), authoredUser.getTenantId(), userId, tmActivityId, workItemIdList);
        List withdrawDataList = ((CommonRetrieveDataService)SpringUtil.getBean(CommonRetrieveDataService.class)).queryRetrieveDataList(authoredUser, tmActivityId, workItemIdList);
        ArrayList resultList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)terminateDataList)) {
            resultList.addAll(terminateDataList);
        }
        if (CollectionUtils.isNotEmpty((Collection)withdrawDataList)) {
            String dateFieldName = "uibot__dateTime";
            withdrawDataList.sort((data1, data2) -> {
                Map map1 = (Map)data1;
                Map map2 = (Map)data1;
                if (!map1.containsKey(dateFieldName) || null == map1.get(dateFieldName)) {
                    return -1;
                }
                if (!map2.containsKey(dateFieldName) || null == map2.get(dateFieldName)) {
                    return 1;
                }
                LocalDateTime dateTime1 = (LocalDateTime)map1.get(dateFieldName);
                LocalDateTime dateTime2 = (LocalDateTime)map2.get(dateFieldName);
                return Boolean.compare(dateTime1.isBefore(dateTime2), true);
            });
            resultList.addAll(withdrawDataList);
        }
        return resultList;
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        String actionId = null != this.getAction() ? this.getAction().getActionId() : this.getActionId();
        ApiMetadata apiMetadata = ((CommonMetadataService)SpringUtil.getBean(CommonMetadataService.class)).getMetadata(executeContext.getLocale(), actionId);
        this.appendCustomFields(apiMetadata);
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }

    private void appendCustomFields(ApiMetadata apiMetadata) {
        if (null == apiMetadata || CollectionUtils.isEmpty((Collection)apiMetadata.getResponseFields())) {
            return;
        }
        MetadataField topField = (MetadataField)apiMetadata.getResponseFields().get(0);
        if (this.skipAppendCustomField(topField)) {
            return;
        }
        MessageUtils messageUtils = (MessageUtils)SpringUtil.getBean(MessageUtils.class);
        LinkedList<MetadataField> allRespFields = new LinkedList<MetadataField>();
        allRespFields.add(this.createCustomField("uibot__operationType", messageUtils.getMessage("shelved_uibot__operation_type")));
        allRespFields.add(this.createCustomField("uibot__userName", messageUtils.getMessage("shelved_uibot__operator")));
        allRespFields.add(this.createCustomField("uibot__dateTime", messageUtils.getMessage("shelved_uibot__operation_dateTime")));
        allRespFields.add(this.createCustomField("uibot__operationReason", messageUtils.getMessage("shelved_uibot__operation_reason")));
        allRespFields.add(this.createTaskNameField());
        allRespFields.addAll(topField.getSubFields());
        topField.setSubFields(allRespFields);
    }

    private boolean skipAppendCustomField(MetadataField topField) {
        if (CollectionUtils.isEmpty((Collection)topField.getSubFields())) {
            return true;
        }
        Optional<MetadataField> optional = topField.getSubFields().stream().filter(subField -> StringUtils.equals((CharSequence)"uibot__operationType", (CharSequence)subField.getName())).findFirst();
        return optional.isPresent();
    }

    private MetadataField createTaskNameField() {
        MetadataField field = new MetadataField();
        field.setName("uibot__initiateActivityName");
        MessageUtils messageUtils = (MessageUtils)SpringUtil.getBean(MessageUtils.class);
        field.setDescription(messageUtils.getMessage("shelved_uibot__taskName"));
        field.setDataKey("false");
        field.setDataType("string");
        ArrayList<TagDefinition> tagDefs = new ArrayList<TagDefinition>();
        field.setTagDefinitions(tagDefs);
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setName("\u6570\u636e\u7ec4\u4ef6");
        tagDefinition.setDescription("\u6570\u636e\u7ec4\u4ef6");
        tagDefinition.setCategory("DATATYPE");
        tagDefinition.setCustomize(Boolean.valueOf(false));
        tagDefinition.setTmTagCode("TYPE_STRING");
        tagDefinition.setCode("TYPE_STRING");
        tagDefinition.setInterpreterServiceName("navigateToTaskInterpreter");
        tagDefs.add(tagDefinition);
        ThemeMapTag themeMapTag = new ThemeMapTag();
        themeMapTag.setName("xxx");
        themeMapTag.setCategory("ORDER");
        themeMapTag.setValue("1");
        themeMapTag.setCode("ORDER_1");
        themeMapTag.setUiBotCode("ORDER");
        tagDefinition.setThemeMapTag(themeMapTag);
        TagDefinition orderTagDef = CustomizeTagUtils.createOrderTagDefinitions("1").get(0);
        orderTagDef.setThemeMapTag(themeMapTag);
        tagDefs.add(orderTagDef);
        return field;
    }

    private MetadataField createCustomField(String name, String description) {
        MetadataField field = new MetadataField();
        field.setName(name);
        field.setDescription(description);
        field.setDataKey("false");
        field.setDataType("string");
        field.setTagDefinitions(this.createTagDefs(field));
        return field;
    }

    private List<TagDefinition> createTagDefs(MetadataField field) {
        ArrayList<TagDefinition> tagDefs = new ArrayList<TagDefinition>();
        TagDefinition typeStringTagDef = CustomizeTagUtils.createDataTypeDefinition(field);
        tagDefs.add(typeStringTagDef);
        ThemeMapTag themeMapTag = new ThemeMapTag();
        themeMapTag.setName("xxx");
        themeMapTag.setCategory("ORDER");
        themeMapTag.setValue("1");
        themeMapTag.setCode("ORDER_1");
        themeMapTag.setUiBotCode("ORDER");
        typeStringTagDef.setThemeMapTag(themeMapTag);
        TagDefinition orderTagDef = CustomizeTagUtils.createOrderTagDefinitions("1").get(0);
        tagDefs.add(orderTagDef);
        orderTagDef.setThemeMapTag(themeMapTag);
        return tagDefs;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        ShelvedDataSource dataSource = new ShelvedDataSource();
        dataSource.setName(this.getName());
        dataSource.setAction(this.getAction());
        dataSource.setType(this.getType());
        dataSource.setDataKeys(this.getDataKeys());
        dataSource.setActionId(this.getActionId());
        return dataSource;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShelvedDataSource)) {
            return false;
        }
        ShelvedDataSource other = (ShelvedDataSource)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ShelvedDataSource;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "ShelvedDataSource()";
    }
}

