/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.process.CustomizeTagUtils;
import com.digiwin.athena.atdm.datasource.datasource.process.dataUniformity.DataUnfiormityProcessor;
import com.digiwin.athena.atdm.datasource.domain.DataSourceProcessor;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.MetadataField;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.domain.TagDefinition;
import com.digiwin.athena.atdm.datasource.domain.ThemeMapTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="retainAbnormalAndAddColumnService")
public class RetainAbnormalAndAddColumnService
implements DataSourceProcessService {
    @Autowired
    private DataUnfiormityProcessor dataUnfiormityProcessor;
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        ArrayList<MetadataField> allSubFields = ((MetadataField)queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().get(0)).getSubFields();
        if (CollectionUtils.isEmpty((Collection)allSubFields)) {
            allSubFields = new ArrayList<MetadataField>();
        }
        MessageUtils messageUtils = (MessageUtils)SpringUtil.getBean(MessageUtils.class);
        MetadataField optTypeField = new MetadataField();
        optTypeField.setName("data_uniformity_optType");
        optTypeField.setDescription(messageUtils.getMessage("data_uniformity_optType"));
        optTypeField.setDataKey("false");
        optTypeField.setDataType("string");
        optTypeField.setTagDefinitions(this.createTagDefs(optTypeField));
        allSubFields.add(optTypeField);
        MetadataField lastModifyTimeField = new MetadataField();
        lastModifyTimeField.setName("data_uniformity_lastModifyTime");
        lastModifyTimeField.setDescription(messageUtils.getMessage("data_uniformity_lastModifyTime"));
        lastModifyTimeField.setDataKey("false");
        lastModifyTimeField.setDataType("string");
        lastModifyTimeField.setTagDefinitions(this.createTagDefs(lastModifyTimeField));
        allSubFields.add(lastModifyTimeField);
        MetadataField dealTypeTimeField = new MetadataField();
        dealTypeTimeField.setName("data_uniformity_dealType");
        dealTypeTimeField.setDescription(messageUtils.getMessage("data_uniformity_dealType"));
        dealTypeTimeField.setDataKey("false");
        dealTypeTimeField.setDataType("string");
        dealTypeTimeField.setCanEdit(true);
        dealTypeTimeField.setTagDefinitions(this.createSelectTagDefs(dealTypeTimeField));
        allSubFields.add(dealTypeTimeField);
        ((MetadataField)queryResult.getApiMetadataCollection().getMasterApiMetadata().getResponseFields().get(0)).setSubFields(allSubFields);
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
    }

    public List<TagDefinition> createTagDefs(MetadataField field) {
        ArrayList<TagDefinition> tagDefs = new ArrayList<TagDefinition>();
        TagDefinition typeStringTagDef = CustomizeTagUtils.createDataTypeDefinition(field);
        tagDefs.add(typeStringTagDef);
        ThemeMapTag themeMapTag = new ThemeMapTag();
        themeMapTag.setName("xxx");
        themeMapTag.setCategory("ORDER");
        themeMapTag.setValue("99999");
        themeMapTag.setCode("ORDER_99999");
        themeMapTag.setUiBotCode("ORDER");
        typeStringTagDef.setThemeMapTag(themeMapTag);
        TagDefinition orderTagDef = CustomizeTagUtils.createOrderTagDefinitions("99999").get(0);
        tagDefs.add(orderTagDef);
        orderTagDef.setThemeMapTag(themeMapTag);
        return tagDefs;
    }

    private List<TagDefinition> createSelectTagDefs(MetadataField field) {
        MessageUtils messageUtils = (MessageUtils)SpringUtil.getBean(MessageUtils.class);
        ArrayList<TagDefinition> tagDefs = new ArrayList<TagDefinition>();
        ThemeMapTag themeMapTag = new ThemeMapTag();
        themeMapTag.setName("xxx");
        themeMapTag.setCategory("ORDER");
        themeMapTag.setValue("99999");
        themeMapTag.setCode("ORDER_99999");
        themeMapTag.setUiBotCode("ORDER");
        TagDefinition orderTagDef = CustomizeTagUtils.createOrderTagDefinitions("99999").get(0);
        orderTagDef.setThemeMapTag(themeMapTag);
        tagDefs.add(orderTagDef);
        TagDefinition selectTagDef = new TagDefinition();
        selectTagDef.setCode("ABNORMAL");
        selectTagDef.setName(field.getName());
        selectTagDef.setDescription(field.getDescription());
        selectTagDef.setCategory("BUSINESS");
        selectTagDef.setInterpreterServiceName("selectInterpreter");
        selectTagDef.setCustomize(Boolean.valueOf(false));
        HashMap extendedInfo = new HashMap();
        selectTagDef.setExtendedInfo(extendedInfo);
        HashMap<String, String> optionsMap = new HashMap<String, String>();
        extendedInfo.put("option", optionsMap);
        optionsMap.put("ignore", messageUtils.getMessage("data_uniformity_dealType_ignore"));
        optionsMap.put("end", messageUtils.getMessage("data_uniformity_dealType_end"));
        tagDefs.add(selectTagDef);
        return tagDefs;
    }
}

