package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.uibot.CommonUiBotService;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;

import java.util.List;
import java.util.Map;

/**
 * @author：SYQ
 * @date：2022/7/19
 */
public class DataUniformotySource extends DataSourceBase {

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        List<Map<String,Object>> dataMap = SpringUtil.getBean(CommonUiBotService.class).getUnfinishedData(executeContext.getTmProjectId(),executeContext.getTmActivityId(),executeContext.getBacklogId().toString());
        QueryResult queryResult = new QueryResult();
        queryResult.setData(dataMap);
        return queryResult;
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        return null;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        return null;
    }
}
