package com.digiwin.athena.atdm.datasource.datasource.process;


import com.digiwin.athena.atdm.activity.ActivityConstants;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.*;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service("appendActivityParameterService")
public class AppendActivityParameterService implements DataSourceProcessService {

    /**
     * 对元数据处理
     *
     * @param dataSourceBase      查询的结果的数据
     * @param executeContext      执行上下文
     * @param dataSourceProcessor 处理器
     * @param queryResult         查询结果
     */
    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        if (!ActivityConstants.TASK_DETAIL.equals(executeContext.getPageCode())) {
            return;
        }
        ApiMetadataCollection apiMetadataCollection  = queryResult.getApiMetadataCollection();
        if (dataSourceProcessor.getParas() == null
                || apiMetadataCollection == null
                || apiMetadataCollection.getMasterApiMetadata() == null
                || apiMetadataCollection.getMasterApiMetadata().getResponseFields().size() ==0) {
            return;
        }
        if (dataSourceBase.getAction() == null
            || dataSourceBase.getAction().getParas() ==null
                || dataSourceBase.getAction().getParas().size()==0){
            return;
        }
        Map<String, String> processParas = (Map<String, String>) dataSourceProcessor.getParas();
        if (!processParas.containsKey("appendParameterName")) {
            return;
        }
        String appendParameterName = processParas.get("appendParameterName");
        Map jsonObject = dataSourceBase.getAction().getParas();
        List<Map<String, Object>> paras = (List<Map<String, Object>>) jsonObject.get(appendParameterName);
        if (paras != null && paras.size() > 0) {
            Map<String, Object> para = paras.get(0);
            if (para.containsKey("fields")) {
                List<TagDefinition> tagDefinitions = CustomizeTagUtils.createOrderTagDefinitions("999");
                ApiMetadata apiMetadata = apiMetadataCollection.getMasterApiMetadata();
                String fields = para.get("fields").toString();
                String field_name = para.get("field_name").toString();
                MetadataField metadataField = new MetadataField();
                metadataField.setName(fields);
                metadataField.setTagDefinitions(tagDefinitions);
                metadataField.setDataType("string");
                metadataField.setDescription(field_name);
                tagDefinitions.add(CustomizeTagUtils.createDataTypeDefinition(metadataField));
                //todo:临时做法
                apiMetadata.getResponseFields().get(0).getSubFields().add(metadataField);
            }
        }
    }

    /**
     * 对数据处理
     *
     * @param dataSourceBase
     * @param executeContext
     * @param dataSourceProcessor 处理器
     * @param queryResult
     */
    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {
        //无需处理
    }

}
