package com.digiwin.athena.atdm.datasource.datasource.process;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atdm.fi.CommonForecastingIntelligenceService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceProcessService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.*;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 智能推荐服务
 */
@Service("recommendProcessService")
public class RecommendProcessService  implements DataSourceProcessService {

    private static final String PLAN_TYPE_REASON_FILED_NAME = "UIBOT_PLAN_TYPE_REASON";

    private static final String PLAN_TYPE_RECOMMEND_FIELD_NAME = "UIBOT_PLAN_TYPE_RECOMMEND_REASON";

    @Autowired
    private CommonForecastingIntelligenceService commonForecastingIntelligenceService;

    @Override
    public void handelMetadata(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {

        ApiMetadataCollection apiMetadataCollection = queryResult.getApiMetadataCollection();
        if(apiMetadataCollection == null){
            return;
        }

        if(apiMetadataCollection!=null
                && apiMetadataCollection.getMasterApiMetadata()!=null
                && CollectionUtils.isNotEmpty(apiMetadataCollection.getMasterApiMetadata().getResponseFields())) {

            List<MetadataField> metadataFields = apiMetadataCollection.getMasterApiMetadata().getResponseFields().get(0).getSubFields();

            MetadataField planTypeReasonField = new MetadataField();
            planTypeReasonField.setUiBot("Y");
            planTypeReasonField.setName( PLAN_TYPE_REASON_FILED_NAME );
            planTypeReasonField.setDataType("string");
            Map<String,Integer> planPrecision =new HashMap<>();
            planPrecision.put("length", 120);
            planTypeReasonField.setPrecision(planPrecision);
            planTypeReasonField.setDescription(MessageUtils.getMessageByCurrentLanguage("{\"zh_TW\":\"方案選擇理由\",\"en_US\":\"Reasons for plan selection\",\"zh_CN\":\"方案选择理由\"}"));
            metadataFields.add(planTypeReasonField);

            MetadataField recommendReasonField = new MetadataField();
            recommendReasonField.setUiBot("Y");
            recommendReasonField.setName( PLAN_TYPE_RECOMMEND_FIELD_NAME );
            recommendReasonField.setDataType("string");
            Map<String,Integer> reasonPrecision =new HashMap<>();
            reasonPrecision.put("length", 120);
            recommendReasonField.setPrecision(reasonPrecision);
            recommendReasonField.setDescription(MessageUtils.getMessageByCurrentLanguage("{\"zh_TW\":\"推薦理由\",\"en_US\":\"Recommended reason\",\"zh_CN\":\"推荐理由\"}"));
            metadataFields.add(recommendReasonField);
        }
    }

    @Override
    public void handelData(DataSourceBase dataSourceBase, ExecuteContext executeContext, DataSourceProcessor dataSourceProcessor, QueryResult queryResult) {

        if(queryResult==null || CollectionUtils.isEmpty(queryResult.getData())){
            return;
        }

        if(CollectionUtils.isEmpty(dataSourceProcessor.getDataSourceNames())
                || dataSourceProcessor.getDataSourceNames().contains(queryResult.getDataSourceName())) {
            Map data = new HashMap();
            for (Map<String, Object> datum : queryResult.getData()) {
                //添加方案选择理由
                datum.put(PLAN_TYPE_REASON_FILED_NAME, "");

                //推荐理由
                datum.put(PLAN_TYPE_RECOMMEND_FIELD_NAME, "");
            }

            data.put(queryResult.getDataSourceName(), queryResult.getData());

            List<Map> fiAmendData = new ArrayList<>();

            if(dataSourceProcessor.getParas() !=null ){
                Map plan = JsonUtils.jsonToObject(JsonUtils.objectToString(dataSourceProcessor.getParas()), Map.class);
                plan.put("dataSourceName", queryResult.getDataSourceName());
                fiAmendData.add(plan);
            }

            Map user = new HashMap();
            user.put("userId", executeContext.getAuthoredUser().getUserId());
            user.put("userName", executeContext.getAuthoredUser().getUserName());
            user.put("tenantId", executeContext.getAuthoredUser().getTenantId());
            user.put("tenantName", executeContext.getAuthoredUser().getTenantName());

            Map task = new HashMap();

            task.put("identity", executeContext.getIdentity());
            TaskWithBacklogData taskWithBacklogData = dataSourceProcessor.getTaskWithBacklogData();

            if (taskWithBacklogData!= null){
                task.put("backlogId", taskWithBacklogData.getBacklog().get(0).getBacklogId());
                task.put("startTime", taskWithBacklogData.getBacklog().get(0).getStartTime());
                task.put("planEndTime", taskWithBacklogData.getBacklog().get(0).getPlanEndTime());
                task.put("backlogName", taskWithBacklogData.getBacklog().get(0).getBacklogName());
                task.put("performerId", taskWithBacklogData.getBacklog().get(0).getPerformerId());
                task.put("performerName", taskWithBacklogData.getBacklog().get(0).getPerformerName());
                task.put("tmActivityId", taskWithBacklogData.getTmActivityId());
                task.put("activityType", taskWithBacklogData.getBpmActivityType());
                task.put("pattern", taskWithBacklogData.getTmPattern());
                task.put("category", taskWithBacklogData.getTmCategory());
            }
            ProjectData projectData = dataSourceProcessor.getProjectData();

            if (projectData!=null) {
                task.put("projectId", projectData.getProjectId());
                task.put("projectName", projectData.getProjectName());
                task.put("tmProjectId", projectData.getTmProjectId());
            }else{
                task.put("projectId", "");
                task.put("projectName", "");
                task.put("tmProjectId", "");
            }
            Map result = commonForecastingIntelligenceService.taskaction(data, user, task, fiAmendData);
            if(MapUtils.isNotEmpty(result) && result.containsKey("data")){
                data = (Map) result.get("data");
                List<Map<String, Object>> list = (List)data.get(queryResult.getDataSourceName());
                //替换掉原有数据源
                queryResult.getData().clear();
                queryResult.getData().addAll(list);
            }
        }

    }

}
