/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.atmc.CommonAtmcService;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.Action;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryAction;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class AtmcOverdueTaskDataSource
extends DataSourceBase {
    private static final String PARA_NAME = "queryMap";

    public AtmcOverdueTaskDataSource() {
        this.setType("ATMC");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> orderInfo, List<Map> searchInfo) {
        QueryAction action = this.getAction();
        String backlogId = null;
        if (action != null && action.getParas() != null && action.getParas().containsKey("backlogId")) {
            backlogId = action.getParas().get("backlogId").toString();
        } else if (parameter != null && parameter.containsKey("backlogId")) {
            backlogId = parameter.get("backlogId").toString();
        }
        if (null == action) {
            return QueryResult.empty((String)this.getName());
        }
        String actionId = action.getActionId();
        if (StringUtils.isEmpty((CharSequence)actionId)) {
            return QueryResult.empty((String)this.getName());
        }
        if (Objects.equals(actionId, "atmc.get.overdue.task.datasource")) {
            return this.getOverdueTaskDataSource(backlogId);
        }
        if (Objects.equals(actionId, "atmc.get.overdue.task.list.datasource")) {
            return this.getOverdueTaskListDataSource(backlogId);
        }
        if (Objects.equals(actionId, "atmc.show.overdue.task.original")) {
            return this.getOverdueTaskListDataSource(backlogId);
        }
        return this.executeAtmcDataSourceDataQuery(executeContext, parameter);
    }

    private QueryResult executeAtmcDataSourceDataQuery(ExecuteContext executeContext, Map<String, Object> parameter) {
        List resultList = ((CommonAtmcService)SpringUtil.getBean(CommonAtmcService.class)).executeDataSourceDataQuery(executeContext, (Action)this.getAction(), parameter);
        HashMap<String, List> data = new HashMap<String, List>();
        data.put("atmc_data", resultList);
        return QueryResult.withData((String)this.getName(), data);
    }

    private QueryResult getOverdueTaskDataSource(String backlogId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("backlogId", backlogId);
        List value = ((CommonAtmcService)SpringUtil.getBean(CommonAtmcService.class)).getOverdueTaskDataSource(map);
        ArrayList list = new ArrayList();
        if (value != null) {
            value.forEach(m -> list.add(m));
        }
        HashMap espData = new HashMap();
        espData.put("atmc_data", list);
        return QueryResult.withData((String)this.getName(), espData);
    }

    private QueryResult getOverdueTaskListDataSource(String backlogId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("backlogId", backlogId);
        List value = ((CommonAtmcService)SpringUtil.getBean(CommonAtmcService.class)).getOverdueTaskListDataSource(map);
        ArrayList list = new ArrayList();
        if (value != null) {
            value.forEach(m -> list.add(m));
        }
        HashMap espData = new HashMap();
        espData.put("atmc_data", list);
        return QueryResult.withData((String)this.getName(), espData);
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = ApiMetadataCollection.empty();
        apiMetadataCollection.getMasterApiMetadata().setActionId(this.getActionId());
        apiMetadataCollection.getMasterApiMetadata().setServiceName(this.getAction().getServiceId().getName());
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        AtmcOverdueTaskDataSource ds = new AtmcOverdueTaskDataSource();
        ds.setName(this.getName());
        ds.setAction(this.getAction());
        ds.setType(this.getType());
        ds.setDataKeys(this.getDataKeys());
        ds.setActionId(this.getActionId());
        return ds;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtmcOverdueTaskDataSource)) {
            return false;
        }
        AtmcOverdueTaskDataSource other = (AtmcOverdueTaskDataSource)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtmcOverdueTaskDataSource;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "AtmcOverdueTaskDataSource()";
    }
}

