/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atdm.datasource.datasource;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.atdm.datasource.datasource.DataSourceBase;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadata;
import com.digiwin.athena.atdm.datasource.domain.ApiMetadataCollection;
import com.digiwin.athena.atdm.datasource.domain.ExecuteContext;
import com.digiwin.athena.atdm.datasource.domain.QueryResult;
import com.digiwin.athena.atdm.datasource.dto.PageInfo;
import com.digiwin.athena.atdm.smartdata.CommonSmartDataService;
import com.digiwin.athena.atdm.thememap.CommonMetadataService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public class SdDataSource
extends DataSourceBase {
    public SdDataSource() {
        this.setType("SD");
    }

    @Override
    protected QueryResult queryCore(ExecuteContext executeContext, Map<String, Object> parameter, PageInfo pageInfo, List<Map> sortInfo, List<Map> searchInfo) {
        if (this.getAction() == null) {
            return QueryResult.empty((String)this.getName());
        }
        HashMap extendedFields = Maps.newHashMap();
        extendedFields.put("application", executeContext.getApplication());
        extendedFields.put("pageCode", executeContext.getPageCode());
        extendedFields.put("tmActivityId", executeContext.getTmActivityId());
        HashMap response = ((CommonSmartDataService)SpringUtil.getBean(CommonSmartDataService.class)).execute(executeContext.getAuthoredUser().getTenantId(), this.getAction().getActionId(), this.getAction().getParas(), executeContext.getBusinessUnit(), (Map)extendedFields);
        if (response == null) {
            return QueryResult.empty((String)this.getName());
        }
        AtomicReference<QueryResult> queryResult = new AtomicReference<QueryResult>();
        response.forEach((k, v) -> {
            if (v instanceof Collection) {
                queryResult.set(QueryResult.withData((String)this.getName(), (List)((List)v)));
            } else if (v instanceof Map) {
                queryResult.set(QueryResult.withSingleData((String)this.getName(), (Map)((Map)v)));
            }
        });
        if (queryResult.get() == null) {
            if (response instanceof Collection) {
                queryResult.set(QueryResult.withData((String)this.getName(), (List)((List)((Object)response))));
            } else if (response instanceof Map) {
                ArrayList<HashMap> dataList = new ArrayList<HashMap>();
                dataList.add(response);
                queryResult.set(QueryResult.withData((String)this.getName(), dataList));
            }
        }
        return (QueryResult)queryResult.get();
    }

    @Override
    protected ApiMetadataCollection queryMetaDataCore(ExecuteContext executeContext, Map<String, Object> parameter, QueryResult queryResult) {
        ApiMetadataCollection apiMetadataCollection = new ApiMetadataCollection();
        ApiMetadata apiMetadata = ((CommonMetadataService)SpringUtil.getBean(CommonMetadataService.class)).getMetadata(executeContext.getLocale(), this.getAction().getActionId());
        apiMetadataCollection.setMasterApiMetadata(apiMetadata);
        return apiMetadataCollection;
    }

    @Override
    protected DataSourceBase copyWithoutProcessorCore() {
        SdDataSource sdDataSource = new SdDataSource();
        sdDataSource.setName(this.getName());
        sdDataSource.setAction(this.getAction());
        sdDataSource.setType(this.getType());
        sdDataSource.setDataKeys(this.getDataKeys());
        sdDataSource.setActionId(this.getActionId());
        return sdDataSource;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SdDataSource)) {
            return false;
        }
        SdDataSource other = (SdDataSource)o;
        return other.canEqual(this);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SdDataSource;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Override
    @Generated
    public String toString() {
        return "SdDataSource()";
    }
}

